/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.processor.DefaultMessageProcessorPathElement;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.config.spring.factories.SubflowMessageProcessorChainFactoryBean;
import org.mule.construct.AbstractPipeline;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.plugins.coverage.Reporter;
import org.mule.munit.plugins.coverage.listeners.Listeners;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;
import org.mule.processor.chain.SubflowInterceptingChainLifecycleWrapper;
import org.mule.routing.ChoiceRouter;
import org.mule.util.NotificationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaModule {
    private static final String SUB_PROCESSORS_TOKEN = "subprocessors";
    private MuleContext context;
    private Reporter reporter = new Reporter();

    public CoberturaModule(MuleContext context) {
        this.context = context;
        this.reporter = new Reporter();
        this.initialise();
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    private void initialise() {
        this.context.getNotificationManager().setNotificationDynamic(true);
        this.context.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        this.context.getNotificationManager().addListener((ServerNotificationListener)Listeners.getMessageProcessorListener(this.reporter));
        this.context.getNotificationManager().addListener((ServerNotificationListener)Listeners.getComponentFiringNotificationListener(this.reporter));
        this.reporter.addFlowPaths(this.buildFlowPathsMap().values());
        this.reporter.addSubFlowPaths(this.buildSubFlowPathsMap().values());
    }

    private Map<MessageProcessor, String> buildFlowPathsMap() {
        HashMap<MessageProcessor, String> pathsMap = new HashMap<MessageProcessor, String>();
        Collection allFlows = this.context.getRegistry().lookupObjects(AbstractPipeline.class);
        for (AbstractPipeline flow : allFlows) {
            if (flow instanceof MunitFlow) continue;
            Map<MessageProcessor, String> paths = this.buildPathsMap(flow);
            this.reformatFlowRefToSubFlowPaths(paths);
            pathsMap.putAll(paths);
        }
        return pathsMap;
    }

    private Map<MessageProcessor, String> buildSubFlowPathsMap() {
        HashMap<MessageProcessor, String> pathsMap = new HashMap<MessageProcessor, String>();
        Collection allSubFlows = this.context.getRegistry().lookupObjects(SubflowMessageProcessorChainFactoryBean.class);
        for (Object subFlow : allSubFlows) {
            SubflowInterceptingChainLifecycleWrapper sf = this.handleMunitSubFlowFromRegistry(subFlow);
            Map<MessageProcessor, String> paths = this.buildPathsMap(sf);
            this.reformatSubFlowsPaths(paths);
            pathsMap.putAll(this.filterOutFlowRefInSubFlow2SubFlow(paths));
        }
        return pathsMap;
    }

    private Map<MessageProcessor, String> buildPathsMap(Object flow) {
        DefaultMessageProcessorPathElement messageProcessorPathElement = AbstractPipeline.class.isAssignableFrom(flow.getClass()) ? this.buildMessageProcessorPathElement((AbstractPipeline)flow) : this.buildMessageProcessorPathElement((SubflowInterceptingChainLifecycleWrapper)flow);
        Map<MessageProcessor, String> filteredSubFlowPaths = this.filterOutInvalidChoiceMessageProcessors(NotificationUtils.buildPaths((MessageProcessorPathElement)messageProcessorPathElement));
        return filteredSubFlowPaths;
    }

    private DefaultMessageProcessorPathElement buildMessageProcessorPathElement(AbstractPipeline flow) {
        DefaultMessageProcessorPathElement pipeLinePathElement = new DefaultMessageProcessorPathElement(null, flow.getName());
        flow.addMessageProcessorPathElements((MessageProcessorPathElement)pipeLinePathElement);
        return pipeLinePathElement;
    }

    private DefaultMessageProcessorPathElement buildMessageProcessorPathElement(SubflowInterceptingChainLifecycleWrapper flow) {
        DefaultMessageProcessorPathElement pipeLinePathElement = new DefaultMessageProcessorPathElement(null, flow.getName());
        flow.addMessageProcessorPathElements((MessageProcessorPathElement)pipeLinePathElement);
        return pipeLinePathElement;
    }

    private SubflowInterceptingChainLifecycleWrapper handleMunitSubFlowFromRegistry(Object subFlow) {
        try {
            SubflowInterceptingChainLifecycleWrapper sf = SubflowInterceptingChainLifecycleWrapper.class.isAssignableFrom(subFlow.getClass()) ? (SubflowInterceptingChainLifecycleWrapper)subFlow : (SubflowInterceptingChainLifecycleWrapper)((SubflowMessageProcessorChainFactoryBean)subFlow).getObject();
            return sf;
        }
        catch (Exception e) {
            throw new RuntimeException("MUnit Cobertura Plugin, there was an error trying to account for sub-flows.", e);
        }
    }

    private void reformatSubFlowsPaths(Map<MessageProcessor, String> filteredSubFlowPaths) {
        for (Map.Entry<MessageProcessor, String> entry : filteredSubFlowPaths.entrySet()) {
            String[] tokens = entry.getValue().split("/");
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(tokens));
            segments.remove(0);
            segments.remove(0);
            String realPath = "/" + StringUtils.join(segments, (String)"/");
            entry.setValue(realPath);
        }
    }

    private void reformatFlowRefToSubFlowPaths(Map<MessageProcessor, String> paths) {
        for (Map.Entry<MessageProcessor, String> entry : paths.entrySet()) {
            String path = entry.getValue();
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(path.split("/")));
            if (segments.size() < 6 || !segments.get(5).equals(SUB_PROCESSORS_TOKEN)) continue;
            String realPath = StringUtils.join(segments.subList(0, 4), (String)"/");
            entry.setValue(realPath);
        }
    }

    private Map<MessageProcessor, String> filterOutFlowRefInSubFlow2SubFlow(Map<MessageProcessor, String> subFlowPaths) {
        HashMap<MessageProcessor, String> filteredPaths = new HashMap<MessageProcessor, String>();
        for (MessageProcessor k : subFlowPaths.keySet()) {
            String path = subFlowPaths.get(k);
            if (StringUtils.countMatches((String)path, (String)SUB_PROCESSORS_TOKEN) > 1) continue;
            filteredPaths.put(k, path);
        }
        return filteredPaths;
    }

    private Map<MessageProcessor, String> filterOutInvalidChoiceMessageProcessors(Map<MessageProcessor, String> messageProcessors) {
        HashMap<MessageProcessor, String> mpMap = new HashMap<MessageProcessor, String>();
        for (Map.Entry<MessageProcessor, String> mp : messageProcessors.entrySet()) {
            if (InterceptingChainLifecycleWrapper.class.isAssignableFrom(mp.getKey().getClass()) || ChoiceRouter.class.isAssignableFrom(mp.getKey().getClass())) continue;
            mpMap.put(mp.getKey(), mp.getValue());
        }
        return mpMap;
    }
}

