/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.munit.plugins.coverage.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter {
    private Set<String> subFlowPaths = new HashSet<String>();
    private Set<String> flowPaths = new HashSet<String>();
    private Set<String> covered = new HashSet<String>();

    public void addCoveredPath(String path) {
        if (this.flowPaths.contains(path)) {
            this.covered.add(path);
            return;
        }
        for (String p : this.flowPaths) {
            if (!path.startsWith(p)) continue;
            this.covered.add(p);
        }
        for (String p : this.subFlowPaths) {
            if (!path.contains(p)) continue;
            this.covered.add(p);
            break;
        }
    }

    public void addFlowPaths(Collection<String> mps) {
        this.flowPaths.addAll(mps);
    }

    public void addSubFlowPaths(Collection<String> mps) {
        this.subFlowPaths.addAll(mps);
    }

    public Report getReport() {
        HashMap<String, Count> pathPerFlow = new HashMap<String, Count>();
        for (String path : this.flowPaths) {
            this.countPath(path, pathPerFlow, "/processors");
        }
        for (String path : this.subFlowPaths) {
            this.countPath(path, pathPerFlow, "/subprocessors");
        }
        double coverage = this.percentage(this.covered.size(), this.flowPaths.size() + this.subFlowPaths.size());
        HashMap<String, Double> containersCoverage = new HashMap<String, Double>();
        for (Map.Entry count : pathPerFlow.entrySet()) {
            containersCoverage.put((String)count.getKey(), this.percentage(((Count)count.getValue()).coveredMp, ((Count)count.getValue()).totalMp));
        }
        return new Report(coverage, containersCoverage, this.covered, this.flowPaths);
    }

    private void countPath(String path, Map<String, Count> pathPerFlow, String tokenFlag) {
        String containerName = path.substring(0, path.indexOf(tokenFlag));
        if (!pathPerFlow.containsKey(containerName)) {
            pathPerFlow.put(containerName, new Count());
        }
        Count count = pathPerFlow.get(containerName);
        ++count.totalMp;
        if (this.covered.contains(path)) {
            ++count.coveredMp;
        }
    }

    private double percentage(int size, int size1) {
        if (size1 != 0) {
            return (double)size / (double)size1 * 100.0;
        }
        return 0.0;
    }

    private class Count {
        int totalMp;
        int coveredMp;

        private Count() {
        }
    }
}

