/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage;


import org.mule.api.MuleContext;
import org.mule.api.context.notification.MessageProcessorNotificationListener;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.munit.plugins.coverage.listeners.Listeners;

//Mule ensure backwards until 4.x org.mule.construct.AbstractPipeline;
//Mule ensure backwards until 4.x org.mule.context.notification.MessageProcessorNotification;

// We just name it as long as they don't change package we should be good org.mule.processor.chain.InterceptingChainLifecycleWrapper
// We just name it as long as they don't change package we should be good org.mule.routing.ChoiceRouter

public class CoberturaModule {
    private static final String SUB_PROCESSORS_TOKEN = "subprocessors";

    private MuleContext context;
    private Reporter reporter = new Reporter();


    public CoberturaModule(MuleContext context) {
        this.context = context;
        this.reporter = new Reporter();
        this.initialise();
    }

    public Reporter getReporter() {
        return reporter;
    }

    private void initialise() {
        // Setup Context
        context.getNotificationManager().setNotificationDynamic(true);
        context.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        context.getNotificationManager().addListener(Listeners.getMessageProcessorListener(reporter));
        context.getNotificationManager().addListener(Listeners.getComponentFiringNotificationListener(reporter));

        PathBuilder pathBuilder = new PathBuilder(context);
        // Set up reporter
        reporter.addFlowPaths(pathBuilder.buildFlowPathsMap().values());
        reporter.addSubFlowPaths(pathBuilder.buildSubFlowPathsMap().values());
        reporter.addBatchPaths(pathBuilder.buildBatchPathsMap().values());
    }
}
