/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mule.munit.plugins.coverage.CoverageCalculator;
import org.mule.munit.plugins.coverage.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter {
    private Set<String> subFlowPaths = new HashSet<String>();
    private Set<String> flowPaths = new HashSet<String>();
    private Set<String> batchPaths = new HashSet<String>();
    private Set<String> coveredPaths = new HashSet<String>();

    public void addCoveredPath(String path) {
        if (this.flowPaths.contains(path)) {
            this.coveredPaths.add(path);
            return;
        }
        if (this.batchPaths.contains(path)) {
            this.coveredPaths.add(path);
            return;
        }
        for (String p : this.flowPaths) {
            if (!path.startsWith(p)) continue;
            this.coveredPaths.add(p);
        }
        for (String p : this.subFlowPaths) {
            if (!path.contains(p)) continue;
            this.coveredPaths.add(p);
            break;
        }
    }

    public void addFlowPaths(Collection<String> mps) {
        this.flowPaths.addAll(mps);
    }

    public void addSubFlowPaths(Collection<String> mps) {
        this.subFlowPaths.addAll(mps);
    }

    public void addBatchPaths(Collection<String> mps) {
        this.batchPaths.addAll(mps);
    }

    public Report getReport() {
        CoverageCalculator calculator = new CoverageCalculator(this.coveredPaths, this.flowPaths, this.subFlowPaths, this.batchPaths);
        CoverageCalculator.CoverageResult result = calculator.calculate();
        return new Report(result.getCoverage(), result.getContainersCoverage(), this.coveredPaths, this.flowPaths);
    }
}

