/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Reporter {

    private Set<String> subFlowPaths = new HashSet();
    private Set<String> flowPaths = new HashSet<String>();
    private Set<String> batchPaths = new HashSet<String>();

    private Set<String> coveredPaths = new HashSet<String>();

    public void addCoveredPath(String path) {
        // Normal Path of any flow
        if (flowPaths.contains(path)) {
            coveredPaths.add(path);
            return;
        }

        if (batchPaths.contains(path)) {
            coveredPaths.add(path);
            return;
        }

        // Flow ref to sub flows in a flow
        for (String p : flowPaths) {
            if (path.startsWith(p)) {
                // We save this path only as it represents the flow ref
                // The path will represent a sub-flow MP itself
                coveredPaths.add(p);
                //  we do not return the method
                // for this flags the flow ref as coveredPaths
                // but we still need to process the sub flow path
            }
        }

        // Sub flow paths
        for (String p : subFlowPaths) {
            if (path.contains(p)) {
                // We save p for this represents the unique sub-flow mp
                // independently from the flow/sub-flow who referenced it
                coveredPaths.add(p);
                break;
            }
        }
    }

    public void addFlowPaths(Collection<String> mps) {
        flowPaths.addAll(mps);
    }

    public void addSubFlowPaths(Collection<String> mps) {
        subFlowPaths.addAll(mps);
    }

    public void addBatchPaths(Collection<String> mps) {
        batchPaths.addAll(mps);
    }

    public Report getReport() {
        CoverageCalculator calculator = new CoverageCalculator(coveredPaths, flowPaths, subFlowPaths, batchPaths);
        CoverageCalculator.CoverageResult result = calculator.calculate();

        Set<String> allPaths = new HashSet<String>();
        allPaths.addAll(flowPaths);
        allPaths.addAll(subFlowPaths);
        allPaths.addAll(batchPaths);

        return new Report(result.getCoverage(), result.getContainersCoverage(), coveredPaths, allPaths);
    }
}
