/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.munit.common.extensions.MunitPlugin;
import org.mule.munit.plugins.coverage.CoberturaModule;
import org.mule.munit.plugins.coverage.RemoteReporter;
import org.mule.munit.plugins.coverage.Report;
import org.mule.util.NumberUtils;

public class CoberturaPlugin
implements MunitPlugin,
MuleContextAware {
    public static final String COBERTURA_PORT_PROPERTY = "cobertura.port";
    private transient Log logger = LogFactory.getLog(this.getClass());
    private final String port = System.getProperty("cobertura.port", null);
    private MuleContext context;
    private CoberturaModule coberturaModule;

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        this.logger.info((Object)"Initialising coverage plugin...");
        if (StringUtils.isNotBlank((String)this.port) && NumberUtils.isDigits((String)this.port)) {
            this.coberturaModule = new CoberturaModule(this.context);
            this.logger.debug((Object)("Coverage plugin initialised. Using port [" + this.port + "]"));
        } else {
            this.logger.debug((Object)"Coverage module did not initialise. No port has been provided");
        }
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
        this.logger.debug((Object)"Stopping coverage plugin...");
        if (StringUtils.isNotBlank((String)this.port) && NumberUtils.isDigits((String)this.port)) {
            Report report = this.coberturaModule.getReporter().getReport();
            Gson gson = new Gson();
            String json = gson.toJson((Object)report);
            new RemoteReporter().run(Integer.valueOf(this.port), json);
            this.logger.debug((Object)"Coverage plugin report sent.");
        }
    }
}

