/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.List;

public class MuleResource {
    private String name;
    private List<MuleFlow> flows = new ArrayList<MuleFlow>();

    private Double coverage = null;
    private Double branchCoverage = null;

    public MuleResource(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public List<MuleFlow> getFlows() {
        return flows;
    }

    public void setFlows(List<MuleFlow> flows) {
        this.flows = flows;
    }


    public Double getBranchCoverage() {
        return branchCoverage;
    }

    public Double getCoverage() {
        if (coverage == null) {
            calculateResourceCoverage();
        }
        return coverage;
    }

    public Integer getMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : flows) {
            count += mf.getPaths().size();
        }
        return count;
    }

    private void calculateResourceCoverage() {
        int resourcePathCount = 0;
        int resourceCoveredPathCount = 0;

        for (MuleFlow flow : flows) {
            resourcePathCount += flow.getPaths().size();
            resourceCoveredPathCount += flow.getCoveredPaths().size();
        }
        if(resourcePathCount == 0){
            coverage = -1.0;
        } else {
            coverage = Double.valueOf((resourceCoveredPathCount * 100) / resourcePathCount);
        }
    }


}
