/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleResource {
    private String name;
    private List<MuleFlow> flows = new ArrayList<MuleFlow>();
    private Double coverage = null;
    private Double branchCoverage = null;

    public MuleResource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<MuleFlow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<MuleFlow> flows) {
        this.flows = flows;
    }

    public Double getBranchCoverage() {
        return this.branchCoverage;
    }

    public Double getCoverage() {
        if (this.coverage == null) {
            this.calculateResourceCoverage();
        }
        return this.coverage;
    }

    public Integer getMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : this.flows) {
            count = count + mf.getPaths().size();
        }
        return count;
    }

    private void calculateResourceCoverage() {
        int resourcePathCount = 0;
        int resourceCoveredPathCount = 0;
        for (MuleFlow flow : this.flows) {
            resourcePathCount += flow.getPaths().size();
            resourceCoveredPathCount += flow.getCoveredPaths().size();
        }
        this.coverage = resourcePathCount == 0 ? Double.valueOf(-1.0) : Double.valueOf(resourceCoveredPathCount * 100 / resourcePathCount);
    }
}

