/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationCoverageReport {
    private Double coverage;
    private Double branchCoverage;
    private List<MuleResource> resources = new ArrayList<MuleResource>();

    public Double getCoverage() {
        return this.coverage;
    }

    public void setCoverage(Double coverage) {
        this.coverage = coverage;
    }

    public Double getBranchCoverage() {
        return this.branchCoverage;
    }

    public void setBranchCoverage(Double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public List<MuleResource> getResources() {
        return this.resources;
    }

    public void setResources(List<MuleResource> resources) {
        this.resources = resources;
    }

    public Integer getApplicationFlowCount() {
        Integer applicationFlowCount = 0;
        for (MuleResource mr : this.resources) {
            applicationFlowCount = applicationFlowCount + mr.getFlows().size();
        }
        return applicationFlowCount;
    }

    public Integer getApplicationMessageProcessorCount() {
        Integer applicationMpCount = 0;
        for (MuleResource mr : this.resources) {
            for (MuleFlow mf : mr.getFlows()) {
                applicationMpCount = applicationMpCount + mf.getPaths().size();
            }
        }
        return applicationMpCount;
    }

    public Integer getApplicationCoveredMessageProcessorCount() {
        Integer applicationMpCount = 0;
        for (MuleResource mr : this.resources) {
            for (MuleFlow mf : mr.getFlows()) {
                applicationMpCount = applicationMpCount + mf.getCoveredPaths().size();
            }
        }
        return applicationMpCount;
    }

    public void setResourcesWeight() {
        Integer totalMpCount = this.getApplicationMessageProcessorCount();
        for (MuleResource mr : this.resources) {
            Double weight = (double)mr.getMessageProcessorCount().intValue() * 100.0 / (double)totalMpCount.intValue();
            mr.setWeight(weight);
        }
    }
}

