/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.CoverageCalculator;
import org.mule.munit.plugins.coverage.PathBuilder;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageReportBuilder {
    private transient Log log = LogFactory.getLog(this.getClass());
    private Set<String> flowsToIgnore = new HashSet<String>();
    private String applicationResources;

    public CoverageReportBuilder(String applicationResources) {
        this.applicationResources = applicationResources;
    }

    public void setFlowsToIgnore(Set<String> flowsToIgnore) {
        this.flowsToIgnore = flowsToIgnore;
    }

    public ApplicationCoverageReport buildReport(Set<String> coveredPaths, Set<String> appFlowPaths, Set<String> appSubFlowPaths, Set<String> appBatchPaths) {
        coveredPaths = this.filterIgnoredFlows(coveredPaths);
        appFlowPaths = this.filterIgnoredFlows(appFlowPaths);
        appSubFlowPaths = this.filterIgnoredFlows(appSubFlowPaths);
        appBatchPaths = this.filterIgnoredFlows(appBatchPaths);
        Map<String, List<String>> filesMap = this.buildFilesFlowMap(this.applicationResources, appFlowPaths);
        this.removeGlobalCatchFromFilesFlowMapIfThereAreNoReferences(filesMap, appFlowPaths, appSubFlowPaths, appBatchPaths);
        Map<String, List<String>> flowsMap = this.buildApplicationFlowPathMap(appFlowPaths, appSubFlowPaths, appBatchPaths);
        CoverageCalculator calculator = new CoverageCalculator(coveredPaths, appFlowPaths, appSubFlowPaths, appBatchPaths);
        CoverageCalculator.CoverageResult coverageResult = calculator.calculate();
        Map<String, List<String>> flowsCoveredPaths = PathBuilder.buildFlowPathsMap(coveredPaths);
        int totalMpCount = 0;
        int coveredMpCount = 0;
        ApplicationCoverageReport report = new ApplicationCoverageReport();
        for (String fileName : filesMap.keySet()) {
            MuleResource muleResource = new MuleResource(fileName);
            List<String> flowsFromFile = filesMap.get(fileName);
            for (String flowName : flowsFromFile) {
                if (this.flowsToIgnore.contains(flowName)) continue;
                MuleFlow muleFlow = new MuleFlow(flowName);
                if (flowsMap.containsKey(flowName)) {
                    muleFlow.getPaths().addAll((Collection<String>)flowsMap.get(flowName));
                    totalMpCount += flowsMap.get(flowName).size();
                }
                if (flowsCoveredPaths.containsKey(flowName)) {
                    muleFlow.getCoveredPaths().addAll((Collection<String>)flowsCoveredPaths.get(flowName));
                    coveredMpCount += flowsCoveredPaths.get(flowName).size();
                }
                muleResource.getFlows().add(muleFlow);
            }
            report.getResources().add(muleResource);
        }
        report.setCoverage((double)coveredMpCount * 100.0 / (double)totalMpCount);
        report.setResourcesWeight();
        return report;
    }

    private Set<String> filterIgnoredFlows(Set<String> paths) {
        if (null != this.flowsToIgnore) {
            return PathBuilder.filterPaths(paths, this.flowsToIgnore);
        }
        return paths;
    }

    private Map<String, List<String>> buildFilesFlowMap(String resources, Set<String> appFlowPaths) {
        HashMap<String, List<String>> filesMap = new HashMap<String, List<String>>();
        this.log.debug((Object)"Building Files flow map...");
        if (resources != null && !resources.equals("")) {
            for (String resource : resources.split(",")) {
                URL fileUrl = this.getClass().getClassLoader().getResource(resource);
                filesMap.put(resource, this.getFlowsFromFile(fileUrl));
            }
        }
        this.log.debug((Object)"Files flow map building done...");
        return filesMap;
    }

    private void removeGlobalCatchFromFilesFlowMapIfThereAreNoReferences(Map<String, List<String>> filesMap, Set<String> appFlowPaths, Set<String> appSubFlowPaths, Set<String> appBatchPaths) {
        HashSet<String> flowNamesInPaths = new HashSet<String>();
        for (String string : appFlowPaths) {
            flowNamesInPaths.add(this.getFlowNameFromPath(string));
        }
        for (String string : appSubFlowPaths) {
            flowNamesInPaths.add(string.split("/")[1]);
        }
        for (String string : appBatchPaths) {
            flowNamesInPaths.add(string.split("/")[1]);
        }
        for (Map.Entry entry : filesMap.entrySet()) {
            ArrayList<String> flows = new ArrayList<String>();
            for (String flow : (List)entry.getValue()) {
                if (!flowNamesInPaths.contains(flow)) continue;
                flows.add(flow);
            }
            entry.setValue(flows);
        }
    }

    private String getFlowNameFromPath(String flowPath) {
        String flowName;
        if (flowPath.contains(":\\/")) {
            flowName = StringUtils.strip((String)StringUtils.join((Object[])flowPath.split("/"), (String)"/", (int)0, (int)3), (String)"/");
            flowName = flowName.replace(":\\/", ":/");
        } else {
            flowName = flowPath.split("/")[1];
        }
        return flowName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFlowsFromFile(URL fileUrl) {
        this.log.debug((Object)("Getting flows from file [" + fileUrl + "]"));
        ArrayList<String> flowNames = new ArrayList<String>();
        String xpathQuery = "//*[local-name()='flow' or local-name()='sub-flow' or local-name()='job' or local-name()='catch-exception-strategy' or local-name()='mapping-exception-strategy']";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(fileUrl.openStream());
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList nl = (NodeList)xpath.compile(xpathQuery).evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node nameAttribute = nl.item(i).getAttributes().getNamedItem("name");
                if (null == nameAttribute) continue;
                flowNames.add(nameAttribute.getNodeValue());
            }
        }
        catch (ParserConfigurationException e) {
            this.log.debug((Object)"Error parsing file", (Throwable)e);
        }
        catch (SAXException e) {
            this.log.debug((Object)"Error parsing file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.log.debug((Object)"File not found", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            this.log.debug((Object)"Error parsing file", (Throwable)e);
        }
        catch (IOException e) {
            this.log.debug((Object)"Error reading file", (Throwable)e);
        }
        finally {
            this.log.debug((Object)("Flow names loaded: " + flowNames));
            return flowNames;
        }
    }

    private Map<String, List<String>> buildApplicationFlowPathMap(Set<String> flows, Set<String> subFlows, Set<String> batches) {
        HashMap<String, List<String>> flowsMap = new HashMap<String, List<String>>();
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(flows));
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(subFlows));
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(batches));
        return flowsMap;
    }
}

