/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.listeners;

import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ComponentMessageNotificationListener;
import org.mule.context.notification.ComponentMessageNotification;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.plugins.coverage.Reporter;

// part of API interface org.mule.context.notification.ComponentMessageNotification

public class ComponentEventFiringNotificationListener implements ComponentMessageNotificationListener<ComponentMessageNotification> {

    private Reporter myReporter;

    ComponentEventFiringNotificationListener(Reporter reporter) {
        myReporter = reporter;
    }

    @Override
    public void onNotification(ComponentMessageNotification componentMessageNotification) {
        FlowConstruct flowConstruct = componentMessageNotification.getFlowConstruct();

        if (flowConstruct instanceof MunitFlow) {
            return;
        }
        myReporter.addCoveredPath(Listeners.getProcessorPath(flowConstruct, componentMessageNotification.getComponent()));
    }


}