/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.processor.DefaultMessageProcessorPathElement;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.config.spring.factories.SubflowMessageProcessorChainFactoryBean;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.AbstractPipeline;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;
import org.mule.processor.chain.SubflowInterceptingChainLifecycleWrapper;
import org.mule.util.NotificationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathBuilder {
    public static final String PROCESSORS_TOKEN = "processors";
    public static final String SUB_PROCESSORS_TOKEN = "subprocessors";
    public static final String EXCEPTION_TOKEN = "es";
    public static final String BATCH_INPUT_TOKEN = "input";
    public static final String BATCH_PROCESS_RECORD_TOKEN = "process-records";
    public static final String BATCH_ON_COMPLETE_TOKEN = "on-complete";
    private static final String PLACE_HOLDER_CHAR = "\\x00";
    private static final String API_KIT_FLOW_ESCAPED_VAR = "\\/";
    private MuleContext context;

    public PathBuilder(MuleContext muleContext) {
        this.context = muleContext;
    }

    public Map<MessageProcessor, String> buildFlowPathsMap() {
        HashMap<MessageProcessor, String> pathsMap = new HashMap<MessageProcessor, String>();
        Collection allFlows = this.context.getRegistry().lookupObjects(AbstractPipeline.class);
        for (AbstractPipeline flow : allFlows) {
            if (flow instanceof MunitFlow) continue;
            Map<MessageProcessor, String> paths = this.buildPathsMap(flow);
            paths = this.reformatGlobalCatchPaths(paths);
            this.reformatFlowRefToSubFlowPaths(paths, false);
            pathsMap.putAll(paths);
        }
        return pathsMap;
    }

    public Map<MessageProcessor, String> buildSubFlowPathsMap() {
        HashMap<MessageProcessor, String> pathsMap = new HashMap<MessageProcessor, String>();
        Collection allSubFlows = this.context.getRegistry().lookupObjects(SubflowMessageProcessorChainFactoryBean.class);
        for (Object subFlow : allSubFlows) {
            SubflowInterceptingChainLifecycleWrapper sf = this.handleMunitSubFlowFromRegistry(subFlow);
            Map<MessageProcessor, String> paths = this.buildPathsMap(sf);
            this.reformatSubFlowsPaths(paths);
            this.reformatFlowRefToSubFlowPaths(paths, true);
            pathsMap.putAll(this.filterOutFlowRefInSubFlow2SubFlow(paths));
        }
        return pathsMap;
    }

    public Map<MessageProcessor, String> buildBatchPathsMap() {
        HashMap<MessageProcessor, String> pathsMap = new HashMap<MessageProcessor, String>();
        Collection allBatchs = this.context.getRegistry().lookupObjects(AbstractFlowConstruct.class);
        for (AbstractFlowConstruct batch : allBatchs) {
            if (!"Batch".equals(batch.getConstructType())) continue;
            Map<MessageProcessor, String> paths = this.buildPathsMap(batch);
            this.reformatFlowRefToSubFlowPaths(paths, false);
            pathsMap.putAll(paths);
        }
        return pathsMap;
    }

    private Map<MessageProcessor, String> buildPathsMap(Object flow) {
        String flowName = AbstractFlowConstruct.class.isAssignableFrom(flow.getClass()) ? ((AbstractFlowConstruct)flow).getName() : ((SubflowInterceptingChainLifecycleWrapper)flow).getName();
        DefaultMessageProcessorPathElement messageProcessorPathElement = this.buildMessageProcessorPathElement((MessageProcessorContainer)flow, flowName);
        return this.filterOutInvalidChoiceMessageProcessors(NotificationUtils.buildPaths((MessageProcessorPathElement)messageProcessorPathElement));
    }

    private DefaultMessageProcessorPathElement buildMessageProcessorPathElement(MessageProcessorContainer flow, String flowName) {
        DefaultMessageProcessorPathElement pipeLinePathElement = new DefaultMessageProcessorPathElement(null, flowName);
        flow.addMessageProcessorPathElements((MessageProcessorPathElement)pipeLinePathElement);
        return pipeLinePathElement;
    }

    private SubflowInterceptingChainLifecycleWrapper handleMunitSubFlowFromRegistry(Object subFlow) {
        try {
            SubflowInterceptingChainLifecycleWrapper sf = SubflowInterceptingChainLifecycleWrapper.class.isAssignableFrom(subFlow.getClass()) ? (SubflowInterceptingChainLifecycleWrapper)subFlow : (SubflowInterceptingChainLifecycleWrapper)((SubflowMessageProcessorChainFactoryBean)subFlow).getObject();
            return sf;
        }
        catch (Exception e) {
            throw new RuntimeException("MUnit Cobertura Plugin, there was an error trying to account for sub-flows.", e);
        }
    }

    private void reformatSubFlowsPaths(Map<MessageProcessor, String> filteredSubFlowPaths) {
        for (Map.Entry<MessageProcessor, String> entry : filteredSubFlowPaths.entrySet()) {
            String[] tokens = entry.getValue().split("/");
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(tokens));
            segments.remove(0);
            segments.remove(0);
            String realPath = "/" + StringUtils.join(segments, (String)"/");
            entry.setValue(realPath);
        }
    }

    private void reformatFlowRefToSubFlowPaths(Map<MessageProcessor, String> paths, boolean subFlowPaths) {
        for (Map.Entry<MessageProcessor, String> entry : paths.entrySet()) {
            int idxOfSecond;
            String path = entry.getValue();
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(path.split("/")));
            if (segments.contains(SUB_PROCESSORS_TOKEN) && !subFlowPaths) {
                String realPath = StringUtils.join(segments.subList(0, segments.indexOf(SUB_PROCESSORS_TOKEN) - 1), (String)"/");
                entry.setValue(realPath);
                continue;
            }
            if (!segments.contains(SUB_PROCESSORS_TOKEN) || !subFlowPaths || (idxOfSecond = this.getSubProcessorsSecondAppearanceIdx(segments)) == -1) continue;
            String realPath = StringUtils.join(segments.subList(0, idxOfSecond - 1), (String)"/");
            entry.setValue(realPath);
        }
    }

    private int getSubProcessorsSecondAppearanceIdx(List<String> segments) {
        int idxOfSecond = -1;
        if (Collections.frequency(segments, SUB_PROCESSORS_TOKEN) >= 2) {
            int i = 0;
            boolean firstPassed = false;
            for (String s : segments) {
                if (s.equals(SUB_PROCESSORS_TOKEN)) {
                    if (!firstPassed) {
                        firstPassed = true;
                    } else {
                        idxOfSecond = i;
                        break;
                    }
                }
                ++i;
            }
        }
        return idxOfSecond;
    }

    private Map<MessageProcessor, String> filterOutFlowRefInSubFlow2SubFlow(Map<MessageProcessor, String> subFlowPaths) {
        HashMap<MessageProcessor, String> filteredPaths = new HashMap<MessageProcessor, String>();
        for (MessageProcessor k : subFlowPaths.keySet()) {
            String path = subFlowPaths.get(k);
            if (StringUtils.countMatches((String)path, (String)SUB_PROCESSORS_TOKEN) > 1) continue;
            filteredPaths.put(k, path);
        }
        return filteredPaths;
    }

    private Map<MessageProcessor, String> filterOutInvalidChoiceMessageProcessors(Map<MessageProcessor, String> messageProcessors) {
        HashMap<MessageProcessor, String> mpMap = new HashMap<MessageProcessor, String>();
        for (Map.Entry<MessageProcessor, String> mp : messageProcessors.entrySet()) {
            MessageProcessor actualMp = mp.getKey();
            if (InterceptingChainLifecycleWrapper.class.isAssignableFrom(actualMp.getClass())) {
                String chainName = ((InterceptingChainLifecycleWrapper)actualMp).getName();
                if (chainName.equals("(inner iterating chain) of null")) continue;
                mpMap.put(actualMp, mp.getValue());
                continue;
            }
            mpMap.put(actualMp, mp.getValue());
        }
        return mpMap;
    }

    private Map<MessageProcessor, String> reformatGlobalCatchPaths(Map<MessageProcessor, String> messageProcessors) {
        HashMap<MessageProcessor, String> mpMap = new HashMap<MessageProcessor, String>();
        for (Map.Entry<MessageProcessor, String> mp : messageProcessors.entrySet()) {
            List<String> segments = Arrays.asList(mp.getValue().split("/"));
            if (segments.size() >= 3 && EXCEPTION_TOKEN.equals(segments.get(3))) {
                String reformattedPath = "/" + StringUtils.join(segments.subList(2, segments.size()), (String)"/");
                mpMap.put(mp.getKey(), reformattedPath);
                continue;
            }
            mpMap.put(mp.getKey(), mp.getValue());
        }
        return mpMap;
    }

    public static Map<String, List<String>> buildFlowPathsMap(Set<String> paths) {
        HashMap<String, List<String>> flowsMap = new HashMap<String, List<String>>();
        for (String p : paths) {
            String flowName;
            String path = p;
            if (path.contains(API_KIT_FLOW_ESCAPED_VAR)) {
                path = path.replace(API_KIT_FLOW_ESCAPED_VAR, PLACE_HOLDER_CHAR);
            }
            if (flowsMap.containsKey(flowName = path.split("/")[1])) {
                ((List)flowsMap.get(flowName)).add(p);
                continue;
            }
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(p);
            flowName = flowName.replace(PLACE_HOLDER_CHAR, "/");
            flowsMap.put(flowName, pathList);
        }
        return flowsMap;
    }

    public static Set<String> filterPaths(Set<String> paths, Set<String> flowNamesToFilter) {
        HashSet<String> filteredPaths = new HashSet<String>();
        for (String path : paths) {
            String flowName = path.split("/")[1];
            if (flowNamesToFilter.contains(flowName)) continue;
            filteredPaths.add(path);
        }
        return filteredPaths;
    }
}

