/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.plugins.coverage.CoverageCalculator;
import org.mule.munit.plugins.coverage.report.SingleRunReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter {
    private Set<String> subFlowPaths = new HashSet<String>();
    private Set<String> flowPaths = new HashSet<String>();
    private Set<String> batchPaths = new HashSet<String>();
    private Set<String> coveredPaths = new HashSet<String>();

    public void addCoveredPath(String path) {
        if (this.flowPaths.contains(path)) {
            this.coveredPaths.add(path);
            return;
        }
        if (this.batchPaths.contains(path)) {
            this.coveredPaths.add(path);
            return;
        }
        this.markPathsInsideGlobalCatchsAsCovered(path);
        this.markFlowRefToSubFlowsAsCovered(path);
        this.markSubFlowPathsAsCovered(path);
    }

    private void markPathsInsideGlobalCatchsAsCovered(String path) {
        List<String> segments = Arrays.asList(path.split("/"));
        if (segments.size() >= 3 && "es".equals(segments.get(3))) {
            String reformattedPath = "/" + StringUtils.join(segments.subList(2, segments.size()), (String)"/");
            for (String p : this.flowPaths) {
                if (!reformattedPath.equals(p)) continue;
                this.coveredPaths.add(p);
                break;
            }
        }
    }

    private void markFlowRefToSubFlowsAsCovered(String path) {
        for (String p : this.flowPaths) {
            if (!path.startsWith(p)) continue;
            this.coveredPaths.add(p);
        }
        for (String p : this.subFlowPaths) {
            if (!path.contains(p) || path.endsWith(p)) continue;
            this.coveredPaths.add(p);
        }
    }

    private void markSubFlowPathsAsCovered(String path) {
        for (String p : this.subFlowPaths) {
            if (!path.endsWith(p)) continue;
            this.coveredPaths.add(p);
            break;
        }
    }

    public void addFlowPaths(Collection<String> mps) {
        this.flowPaths.addAll(mps);
    }

    public void addSubFlowPaths(Collection<String> mps) {
        this.subFlowPaths.addAll(mps);
    }

    public void addBatchPaths(Collection<String> mps) {
        this.batchPaths.addAll(mps);
    }

    public SingleRunReport getReport() {
        CoverageCalculator calculator = new CoverageCalculator(this.coveredPaths, this.flowPaths, this.subFlowPaths, this.batchPaths);
        CoverageCalculator.CoverageResult result = calculator.calculate();
        HashSet<String> allPaths = new HashSet<String>();
        allPaths.addAll(this.flowPaths);
        allPaths.addAll(this.subFlowPaths);
        allPaths.addAll(this.batchPaths);
        return new SingleRunReport(result.getCoverage(), result.getContainersCoverage(), this.coveredPaths, allPaths);
    }
}

