/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.listeners;

import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.plugins.coverage.Reporter;

public class Listeners
{

    public static String getProcessorPath(FlowConstruct fc, MessageProcessor processor)
    {
        if (!(fc instanceof Pipeline))
        {
            return null;
        }
        return ((Pipeline) fc).getProcessorPath(processor);
    }

    public static MessageProcessorEventFiringNotificationListener getMessageProcessorListener(Reporter reporter)
    {
        return new MessageProcessorEventFiringNotificationListener(reporter);
    }

    public static ComponentEventFiringNotificationListener getComponentFiringNotificationListener(Reporter reporter)
    {
        return new ComponentEventFiringNotificationListener(reporter);
    }
}
