/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MuleFlow {
    private String name;

    private Double coverage;
    private Double branchCoverage;

    private List<String> paths = new ArrayList<String>();
    private List<String> coveredPaths = new ArrayList<String>();

    public MuleFlow(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public Double getCoverage() {
        if (null == coverage) {
            calculateResourceCoverage();
        }
        return coverage;
    }

    public String getNameFormatted() {
        return name.replace("\\/", "/");
    }

    public Double getBranchCoverage() {
        return branchCoverage;
    }

    public String getCoverageFormatted() { return String.format(Locale.ENGLISH, "%.2f", coverage); }

    public void setBranchCoverage(Double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public List<String> getPaths() {
        return paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<String> getCoveredPaths() {
        return coveredPaths;
    }

    public void setCoveredPaths(List<String> coveredPaths) {
        this.coveredPaths = coveredPaths;
    }

    private void calculateResourceCoverage() {
        int pathCount = paths.size();
        int coveredPathCount = coveredPaths.size();

        if (pathCount == 0) {
            coverage = -1.0;
        } else {
            coverage = Double.valueOf((coveredPathCount * 100) / (double)pathCount);
        }
    }
}
