/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.server;

import com.google.gson.Gson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.report.SingleRunReport;

import java.io.IOException;
import java.io.ObjectInputStream;

public class CoverageMessageParser implements Runnable {
    private transient Log log = LogFactory.getLog(this.getClass());

    private ObjectInputStream in;
    private ReportAccumulator reportAccumulator;

    public CoverageMessageParser(ObjectInputStream in, ReportAccumulator reportAccumulator) {
        this.in = in;
        this.reportAccumulator = reportAccumulator;
    }

    public void run() {
        try {
            String message = (String) in.readObject();
            SingleRunReport report = new Gson().fromJson(message, SingleRunReport.class);
            accumulateClientReport(report);
        } catch (ClassNotFoundException e) {
            log.error("Fail to deserialize coverage report when received.", e);
        } catch (IOException ioException) {
            log.debug("Coverage connection closed.");
        } finally {
            try {
                if (null != in) {
                    in.close();
                }
            } catch (IOException e) {
                log.debug("Fail to release Coverage server client connection resources.");
            }
        }
    }

    private void accumulateClientReport(SingleRunReport report) {
        reportAccumulator.accumulateReport(report);
    }
}