/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.plugins.coverage.path.PathParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathFormatter {
    private static final String PATH_SEPARATOR = "/";

    public static Map reformatSubFlowPaths(Map paths) {
        PathFormatter.reformatSubFlowsPaths(paths);
        PathFormatter.reformatFlowRefToSubFlowPaths(paths, true);
        return paths;
    }

    private static void reformatFlowRefToSubFlowPaths(Map<MessageProcessor, String> paths, boolean subFlowPaths) {
        for (Map.Entry<MessageProcessor, String> entry : paths.entrySet()) {
            int idxOfSecond;
            String path = entry.getValue();
            ArrayList<String> segments = new ArrayList<String>(Arrays.asList(PathParser.getTokens(path)));
            if (PathParser.containsSubProcessorToken(segments) && !subFlowPaths) {
                String realPath = StringUtils.join(segments.subList(0, PathParser.getSubProcessorTokenIndex(segments) - 1), (String)PATH_SEPARATOR);
                entry.setValue(realPath);
            }
            if (!PathParser.containsSubProcessorToken(segments) || !subFlowPaths || (idxOfSecond = PathParser.getSubProcessorsSecondAppearanceIdx(segments)) == -1) continue;
            String realPath = StringUtils.join(segments.subList(0, idxOfSecond - 1), (String)PATH_SEPARATOR);
            entry.setValue(realPath);
        }
    }

    private static void reformatSubFlowsPaths(Map<MessageProcessor, String> filteredSubFlowPaths) {
        for (Map.Entry<MessageProcessor, String> entry : filteredSubFlowPaths.entrySet()) {
            String[] tokens = PathParser.getTokens(entry.getValue());
            Object[] segments = Arrays.copyOfRange(tokens, 2, tokens.length);
            String realPath = PATH_SEPARATOR + StringUtils.join((Object[])segments, (String)PATH_SEPARATOR);
            entry.setValue(realPath);
        }
    }

    public static Map reformatBatchPaths(Map paths) {
        PathFormatter.reformatFlowRefToSubFlowPaths(paths, false);
        return paths;
    }

    public static Map reformatFlowPaths(Map paths) {
        paths = PathFormatter.reformatGlobalCatchPaths(paths);
        PathFormatter.reformatFlowRefToSubFlowPaths(paths, false);
        return paths;
    }

    private static Map<MessageProcessor, String> reformatGlobalCatchPaths(Map<MessageProcessor, String> messageProcessors) {
        HashMap<MessageProcessor, String> mpMap = new HashMap<MessageProcessor, String>();
        for (Map.Entry<MessageProcessor, String> mp : messageProcessors.entrySet()) {
            List<String> segments = Arrays.asList(PathParser.getTokens(mp.getValue()));
            if (PathParser.isGlobalCatchExceptionStrategy(segments)) {
                String reformattedPath = PathFormatter.buildReformattedPathOfGlobalCatchExceptionStrategy(segments);
                mpMap.put(mp.getKey(), reformattedPath);
                continue;
            }
            mpMap.put(mp.getKey(), mp.getValue());
        }
        return mpMap;
    }

    public static String buildReformattedPathOfGlobalCatchExceptionStrategy(List<String> segments) {
        return PATH_SEPARATOR + StringUtils.join(segments.subList(2, segments.size()), (String)PATH_SEPARATOR);
    }

    public static String getFormattedFlowName(String flowName) {
        return flowName.replaceAll("(?<!\\\\)/", "\\\\/");
    }
}

