/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.munit.plugins.coverage.path.PathBuilder;
import org.mule.munit.plugins.coverage.report.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.FileFlowMap;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageReportBuilder {
    private int coveredMpCount;
    private int totalMpCount;
    private Set<String> flowsToIgnore = new HashSet<String>();
    private Set<String> coveredPaths;
    private String applicationResources;
    private Set<String> appFlowPaths;
    private Set<String> appSubFlowPaths;
    private Set<String> appBatchPaths;
    private FileFlowMap filesMap = new FileFlowMap();
    private Map<String, List<String>> flowsMap;
    private Map<String, List<String>> flowsCoveredPaths;
    private ApplicationCoverageReport report;

    public CoverageReportBuilder() {
        this.reset();
    }

    public CoverageReportBuilder setApplicationResources(String applicationResources) {
        this.applicationResources = applicationResources;
        return this;
    }

    public CoverageReportBuilder setFlowsToIgnore(Set<String> flowsToIgnore) {
        this.flowsToIgnore = flowsToIgnore;
        return this;
    }

    public CoverageReportBuilder setCoveredPaths(Set<String> coveredPaths) {
        this.coveredPaths = this.filterIgnoredFlows(coveredPaths);
        return this;
    }

    public CoverageReportBuilder setAppFlowPaths(Set<String> appFlowPaths) {
        this.appFlowPaths = this.filterIgnoredFlows(appFlowPaths);
        return this;
    }

    public CoverageReportBuilder setAppSubFlowPaths(Set<String> appSubFlowPaths) {
        this.appSubFlowPaths = this.filterIgnoredFlows(appSubFlowPaths);
        return this;
    }

    public CoverageReportBuilder setAppBatchPaths(Set<String> appBatchPaths) {
        this.appBatchPaths = this.filterIgnoredFlows(appBatchPaths);
        return this;
    }

    private Set<String> filterIgnoredFlows(Set<String> paths) {
        return PathBuilder.filterIgnoredFlows(paths, this.flowsToIgnore);
    }

    public ApplicationCoverageReport build() {
        if (this.report != null) {
            return this.report;
        }
        this.report = new ApplicationCoverageReport();
        this.filesMap.build(this.applicationResources, this.appFlowPaths, this.appSubFlowPaths, this.appBatchPaths);
        this.flowsMap = PathBuilder.buildApplicationFlowPathMap(this.appFlowPaths, this.appSubFlowPaths, this.appBatchPaths);
        this.flowsCoveredPaths = PathBuilder.buildFlowPathsMap(this.coveredPaths);
        this.addMuleResourcesAndCount();
        this.report.setCoverage((double)this.coveredMpCount * 100.0 / (double)this.totalMpCount);
        this.report.setResourcesWeight();
        return this.report;
    }

    private void addMuleResourcesAndCount() {
        for (String fileName : this.filesMap.getFiles()) {
            MuleResource muleResource = this.buildMuleResource(fileName);
            this.report.getResources().add(muleResource);
        }
    }

    private MuleResource buildMuleResource(String fileName) {
        MuleResource muleResource = new MuleResource(fileName);
        List<String> flowsFromFile = this.filesMap.get(fileName);
        this.addNotIgnoredFlowsToMuleResource(flowsFromFile, muleResource);
        return muleResource;
    }

    private void addNotIgnoredFlowsToMuleResource(List<String> flowsFromFile, MuleResource muleResource) {
        for (String flowName : flowsFromFile) {
            if (this.flowsToIgnore.contains(flowName)) continue;
            MuleFlow muleFlow = new MuleFlow(flowName);
            this.addFlowIfPresentInFlowsMap(muleFlow);
            this.addFlowToCoveredPathsIfPresentInCoveredFlowsMap(muleFlow);
            muleResource.getFlows().add(muleFlow);
        }
    }

    private void addFlowToCoveredPathsIfPresentInCoveredFlowsMap(MuleFlow muleFlow) {
        String flowName = muleFlow.getName();
        if (this.flowsCoveredPaths.containsKey(flowName)) {
            muleFlow.getCoveredPaths().addAll((Collection<String>)this.flowsCoveredPaths.get(flowName));
            this.coveredMpCount += this.flowsCoveredPaths.get(flowName).size();
        }
    }

    private void addFlowIfPresentInFlowsMap(MuleFlow muleFlow) {
        String flowName = muleFlow.getName();
        if (this.flowsMap.containsKey(flowName)) {
            muleFlow.getPaths().addAll((Collection<String>)this.flowsMap.get(flowName));
            this.totalMpCount += this.flowsMap.get(flowName).size();
        }
    }

    public void reset() {
        this.totalMpCount = 0;
        this.coveredMpCount = 0;
        this.report = null;
    }
}

