/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleFlow {
    private String name;
    private Double coverage;
    private Double branchCoverage;
    private List<String> paths = new ArrayList<String>();
    private List<String> coveredPaths = new ArrayList<String>();

    public MuleFlow(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Double getCoverage() {
        if (null == this.coverage) {
            this.calculateResourceCoverage();
        }
        return this.coverage;
    }

    public String getNameFormatted() {
        return this.name.replace("\\/", "/");
    }

    public Double getBranchCoverage() {
        return this.branchCoverage;
    }

    public String getCoverageFormatted() {
        return String.format(Locale.ENGLISH, "%.2f", this.coverage);
    }

    public void setBranchCoverage(Double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<String> getCoveredPaths() {
        return this.coveredPaths;
    }

    public void setCoveredPaths(List<String> coveredPaths) {
        this.coveredPaths = coveredPaths;
    }

    private void calculateResourceCoverage() {
        int pathCount = this.paths.size();
        int coveredPathCount = this.coveredPaths.size();
        this.coverage = pathCount == 0 ? Double.valueOf(-1.0) : Double.valueOf((double)(coveredPathCount * 100) / (double)pathCount);
    }
}

