/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage;

import com.google.gson.Gson;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.munit.common.extensions.MunitPlugin;
import org.mule.munit.plugins.coverage.report.SingleRunReport;
import org.mule.util.NumberUtils;


public class CoberturaPlugin implements MunitPlugin, MuleContextAware {
    public static final String COBERTURA_PORT_PROPERTY = "cobertura.port";

    private transient Log logger = LogFactory.getLog(this.getClass());

    private final String port;
    private MuleContext context;
    private CoberturaModule coberturaModule;

    public CoberturaPlugin() {
        port = System.getProperty(COBERTURA_PORT_PROPERTY, null);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialise() throws InitialisationException {
        logger.info("Initialising coverage plugin...");

        if (StringUtils.isNotBlank(port) && NumberUtils.isDigits(port)) {
            this.coberturaModule = new CoberturaModule(context);
            logger.debug("Coverage plugin initialised. Using port [" + port + "]");
        } else {
            logger.debug("Coverage module did not initialise. No port has been provided");
        }

    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    @Override
    public void start() throws MuleException {
    }

    @Override
    public void stop() throws MuleException {
        logger.debug("Stopping coverage plugin...");
        if (StringUtils.isNotBlank(port) && NumberUtils.isDigits(port)) {
            SingleRunReport report = coberturaModule.getReporter().getReport();
            Gson gson = new Gson();
            String json = gson.toJson(report);
            new RemoteReporter().run(Integer.valueOf(port), json);

            logger.debug("Coverage plugin report sent.");
        }
    }
}
