/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.report.SingleRunReport;
import org.mule.munit.plugins.coverage.server.ReportAccumulator;

public class CoverageMessageParser
implements Runnable {
    private transient Log log = LogFactory.getLog(this.getClass());
    private ObjectInputStream in;
    private ReportAccumulator reportAccumulator;

    public CoverageMessageParser(ObjectInputStream in, ReportAccumulator reportAccumulator) {
        this.in = in;
        this.reportAccumulator = reportAccumulator;
    }

    public void run() {
        try {
            String message = (String)this.in.readObject();
            SingleRunReport report = (SingleRunReport)new Gson().fromJson(message, SingleRunReport.class);
            this.accumulateClientReport(report);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)"Fail to deserialize coverage report when received.", (Throwable)e);
        }
        catch (IOException ioException) {
            this.log.debug((Object)"Coverage connection closed.");
        }
        finally {
            try {
                if (null != this.in) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                this.log.debug((Object)"Fail to release Coverage server client connection resources.");
            }
        }
    }

    private void accumulateClientReport(SingleRunReport report) {
        this.reportAccumulator.accumulateReport(report);
    }
}

