/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.path.PathFormatter;
import org.mule.munit.plugins.coverage.path.PathParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFlowMap {
    private transient Log log = LogFactory.getLog(this.getClass());
    private Map<String, List<String>> filesMap;

    public Set<String> getFiles() {
        return this.filesMap.keySet();
    }

    public void build(String resources, Set<String> appFlowPaths, Set<String> appSubFlowPaths, Set<String> appBatchPaths) {
        this.filesMap = new HashMap<String, List<String>>();
        this.log.debug((Object)"Building Files flow map...");
        if (resources != null && !resources.equals("")) {
            for (String resource : resources.split(",")) {
                URL fileUrl = this.getClass().getClassLoader().getResource(resource);
                this.filesMap.put(resource, this.getFlowsFromFile(fileUrl));
            }
        }
        this.removeGlobalCatchIfThereAreNoReferences(appFlowPaths, appSubFlowPaths, appBatchPaths);
        this.log.debug((Object)"Files flow map building done...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFlowsFromFile(URL fileUrl) {
        this.log.debug((Object)("Getting flows from file [" + fileUrl + "]"));
        ArrayList<String> flowNames = new ArrayList<String>();
        String xpathQuery = "//*[local-name()='flow' or local-name()='sub-flow' or local-name()='job' or local-name()='catch-exception-strategy' or local-name()='mapping-exception-strategy']";
        try {
            NodeList nodeList = this.buildNodeList(fileUrl, xpathQuery);
            this.addFlowFromNodeList(nodeList, flowNames);
        }
        catch (ParserConfigurationException e) {
            this.log.debug((Object)"Error parsing file", (Throwable)e);
        }
        catch (SAXException e) {
            this.log.debug((Object)"Error parsing file", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            this.log.debug((Object)"File not found", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            this.log.debug((Object)"Error parsing file", (Throwable)e);
        }
        catch (IOException e) {
            this.log.debug((Object)"Error reading file", (Throwable)e);
        }
        finally {
            this.log.debug((Object)("Flow names loaded: " + flowNames));
            return flowNames;
        }
    }

    private NodeList buildNodeList(URL fileUrl, String xpathQuery) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilder builder = this.createBuilder();
        Document doc = builder.parse(fileUrl.openStream());
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (NodeList)xpath.compile(xpathQuery).evaluate(doc, XPathConstants.NODESET);
    }

    private DocumentBuilder createBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    private void addFlowFromNodeList(NodeList nodeList, List<String> flowNames) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node nameAttribute = nodeList.item(i).getAttributes().getNamedItem("name");
            if (null == nameAttribute) continue;
            flowNames.add(PathFormatter.getFormattedFlowName(nameAttribute.getNodeValue()));
        }
    }

    public List<String> get(String fileName) {
        return this.filesMap.get(fileName);
    }

    private void removeGlobalCatchIfThereAreNoReferences(Set<String> appFlowPaths, Set<String> appSubFlowPaths, Set<String> appBatchPaths) {
        HashSet<String> flowNamesInPaths = new HashSet<String>();
        this.addFlowNames(flowNamesInPaths, appFlowPaths);
        this.addFlowNames(flowNamesInPaths, appSubFlowPaths);
        this.addFlowNames(flowNamesInPaths, appBatchPaths);
        for (Map.Entry<String, List<String>> e : this.filesMap.entrySet()) {
            ArrayList<String> flows = new ArrayList<String>();
            for (String flow : e.getValue()) {
                if (!flowNamesInPaths.contains(flow)) continue;
                flows.add(flow);
            }
            e.setValue(flows);
        }
    }

    private void addFlowNames(Set<String> flowNamesInPaths, Set<String> paths) {
        for (String p : paths) {
            flowNamesInPaths.add(PathParser.getFlowName(p));
        }
    }
}

