/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package org.mule.munit.plugins.coverage.path;

import org.apache.commons.lang.StringUtils;

import java.util.*;

public class PathParser {
    public static final String PROCESSORS_TOKEN = "processors";
    public static final String SUB_PROCESSORS_TOKEN = "subprocessors";

    public static final String EXCEPTION_TOKEN  = "es";

    public static final String BATCH_INPUT_TOKEN = "input";
    public static final String BATCH_PROCESS_RECORD_TOKEN = "process-records";
    public static final String BATCH_ON_COMPLETE_TOKEN = "on-complete";

    public static final String SLASHES_THAT_ARE_NOT_PRECEDED_BY_BACKSLASH = "(?<!\\\\)/";

    public static String getFlowName(String path) {
        return getTokens(path)[1];
    }

    public static String[] getTokens(String path) {
        return path.split(SLASHES_THAT_ARE_NOT_PRECEDED_BY_BACKSLASH);
    }

    public static boolean isGlobalCatchExceptionStrategy(List<String> segments) {
        return segments.size() >= 3 && EXCEPTION_TOKEN.equals(segments.get(3));
    }

    public static boolean doesNotHaveFlowRefToSubFlow(String path) {
        return !(StringUtils.countMatches(path, SUB_PROCESSORS_TOKEN) > 1);
    }

    /**
     * It returns the index of the second appearance of the token SUB_PROCESSORS_TOKEN
     *
     * @param segments list of path segments
     * @return -1 if there is no second token, or the index in which the token was founded for the second time
     */
    public static int getSubProcessorsSecondAppearanceIdx(List<String> segments) {
        int counter = 0;
        for(int i = 0; i < segments.size(); ++i) {
            if(segments.get(i).equals(SUB_PROCESSORS_TOKEN)) {
                counter++;
                if(counter == 2) {
                    return i;
                }
            }
        }
        return -1;
    }

    public static boolean containsSubProcessorToken(List<String> segments) {
        return segments.contains(SUB_PROCESSORS_TOKEN);
    }

    public static int getSubProcessorTokenIndex(List<String> segments) {
        return segments.indexOf(SUB_PROCESSORS_TOKEN);
    }

    public static boolean hasParentPath(String path) {
        return path.contains(PROCESSORS_TOKEN) || path.contains(SUB_PROCESSORS_TOKEN) || path.contains(EXCEPTION_TOKEN);
    }

    public static String getParentPath(String path) {
        String parentPath = "";
        if (hasParentPath(path)) {
            String[] tokens = path.split(SLASHES_THAT_ARE_NOT_PRECEDED_BY_BACKSLASH);
            if (tokens.length > 4) {
                parentPath = StringUtils.join(tokens, "/", 0, tokens.length - 1);
            }
        }
        return parentPath;
    }
}
