/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MuleResource {
    private String name;
    private List<MuleFlow> flows = new ArrayList<MuleFlow>();

    private Double coverage = null;
    private Double branchCoverage = null;
    private Double weight = null;

    public MuleResource(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public List<MuleFlow> getFlows() {
        return flows;
    }

    public void setFlows(List<MuleFlow> flows) {
        this.flows = flows;
    }

    public Double getBranchCoverage() {
        return branchCoverage;
    }

    public Double getWeight() {
        return weight;
    }

    public String getWeightFormatted() {
        return String.format(Locale.ENGLISH, "%.2f", weight);
    }

    public String getCoverageFormatted() { return String.format(Locale.ENGLISH, "%.2f", coverage); }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Double getCoverage() {
        if (coverage == null) {
            calculateResourceCoverage();
        }
        return coverage;
    }

    public Integer getMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : flows) {
            count += mf.getPaths().size();
        }
        return count;
    }

    public Integer getCoveredMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : flows) {
            count += mf.getCoveredPaths().size();
        }
        return count;
    }

    private void calculateResourceCoverage() {
        int resourcePathCount = getMessageProcessorCount();
        int resourceCoveredPathCount = getCoveredMessageProcessorCount();
        if(resourcePathCount == 0){
            coverage = -1.0;
        } else {
            coverage = Double.valueOf((resourceCoveredPathCount * 100) / (double)resourcePathCount);
        }
    }


}
