/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.report.SingleRunReport;
import org.mule.munit.plugins.coverage.server.CoverageMessageParser;
import org.mule.munit.plugins.coverage.server.ReportAccumulator;

public class MunitCoverageServer
implements Runnable,
ReportAccumulator {
    private static final int SOCKET_TIMEOUT_MILLIS = 1800000;
    private transient Log log = LogFactory.getLog(this.getClass());
    private int port;
    private boolean running = false;
    private boolean keepRunning = true;
    private ReportAccumulator reportAccumulator;

    public MunitCoverageServer(Integer port, ReportAccumulator reportAccumulator) {
        Validate.notNull((Object)port, (String)"The port can not be null");
        Validate.notNull((Object)reportAccumulator, (String)"The report accumulator can not be null");
        this.port = port;
        this.reportAccumulator = reportAccumulator;
    }

    public synchronized void launch() {
        if (this.running) {
            throw new RuntimeException("The Coverage server is already running it can not be started again.");
        }
        new Thread(this).start();
    }

    public synchronized void shutdown() {
        this.running = false;
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        this.keepRunning = true;
        ServerSocket providerSocket = null;
        try {
            providerSocket = new ServerSocket(this.port, 10);
            this.log.debug((Object)("Coverage server started listening in port [" + this.port + "]..."));
            providerSocket.setSoTimeout(1800000);
            do {
                this.log.info((Object)"Waiting for coverage connection ");
                Socket connection = providerSocket.accept();
                this.log.info((Object)("Coverage connection received from " + connection.getInetAddress().getHostName() + " - " + this.keepRunning));
                CoverageMessageParser parser = new CoverageMessageParser(new ObjectInputStream(connection.getInputStream()), this);
                new Thread(parser).run();
            } while (this.keepRunning);
        }
        catch (SocketTimeoutException timeoutException) {
            this.log.debug((Object)"Coverage server time out");
            if (this.keepRunning) {
                this.log.error((Object)("Coverage connection timeout after " + String.valueOf(1800000) + " milliseconds"));
            }
        }
        catch (IOException ioException) {
            this.log.error((Object)("Failed to start Coverage server in port " + this.port));
        }
        finally {
            try {
                this.log.debug((Object)("Shutting down coverage server running in port [" + this.port + "]..."));
                if (null != providerSocket) {
                    providerSocket.close();
                }
                this.running = false;
                this.keepRunning = false;
                this.log.debug((Object)"Coverage server shutdown");
            }
            catch (IOException ioException) {
                this.log.debug((Object)"Coverage server error during shutdown.");
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void accumulateReport(SingleRunReport report) {
        this.reportAccumulator.accumulateReport(report);
    }
}

