/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleResource {
    private String name;
    private List<MuleFlow> flows = new ArrayList<MuleFlow>();
    private Double coverage = null;
    private Double branchCoverage = null;
    private Double weight = null;

    public MuleResource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<MuleFlow> getFlows() {
        return this.flows;
    }

    public void setFlows(List<MuleFlow> flows) {
        this.flows = flows;
    }

    public Double getBranchCoverage() {
        return this.branchCoverage;
    }

    public Double getWeight() {
        return this.weight;
    }

    public String getWeightFormatted() {
        return String.format(Locale.ENGLISH, "%.2f", this.weight);
    }

    public String getCoverageFormatted() {
        return String.format(Locale.ENGLISH, "%.2f", this.coverage);
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public Double getCoverage() {
        if (this.coverage == null) {
            this.calculateResourceCoverage();
        }
        return this.coverage;
    }

    public Integer getMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : this.flows) {
            count = count + mf.getPaths().size();
        }
        return count;
    }

    public Integer getCoveredMessageProcessorCount() {
        Integer count = 0;
        for (MuleFlow mf : this.flows) {
            count = count + mf.getCoveredPaths().size();
        }
        return count;
    }

    private void calculateResourceCoverage() {
        int resourcePathCount = this.getMessageProcessorCount();
        int resourceCoveredPathCount = this.getCoveredMessageProcessorCount();
        this.coverage = resourcePathCount == 0 ? Double.valueOf(-1.0) : Double.valueOf((double)(resourceCoveredPathCount * 100) / (double)resourcePathCount);
    }
}

