/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;


public class RemoteReporter
{

    Socket requestSocket;
    ObjectOutputStream out;

    public void run(int port, String report)
    {
        try
        {
            //1. creating a socket to connect to the server
            requestSocket = new Socket("localhost", port);
            System.out.println("Connected to localhost in port " + port);
            out = new ObjectOutputStream(requestSocket.getOutputStream());

            out.writeObject(report);
            out.flush();

        }
        catch (IOException ioException)
        {
            ioException.printStackTrace();
        }
        finally
        {
            try
            {
                out.close();
                requestSocket.close();
            }
            catch (IOException ioException)
            {
                ioException.printStackTrace();
            }
        }
    }


}

