/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class SingleRunReport implements Serializable
{
    private static final long serialVersionUID = 42L;

    private double coverage;
    private Map<String, Double> containersCoverage;
    private Set<String> coveredPaths;
    private Set<String> allPaths;

    public SingleRunReport(double coverage, Map<String, Double> containersCoverage, Set<String> coveredPaths, Set<String> allPaths)
    {
        this.coverage = coverage;
        this.containersCoverage = containersCoverage;
        this.coveredPaths = coveredPaths;
        this.allPaths = allPaths;
    }

    public double getCoverage()
    {
        return coverage;
    }

    public Map<String, Double> getContainersCoverage()
    {
        return containersCoverage;
    }

    public Set<String> getCoveredPaths()
    {
        return coveredPaths;
    }

    public Set<String> getAllPaths()
    {
        return allPaths;
    }
}
