/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.path;

import com.google.common.base.Function;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.processor.DefaultMessageProcessorPathElement;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.config.spring.factories.SubflowMessageProcessorChainFactoryBean;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.AbstractPipeline;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.plugins.coverage.path.PathFormatter;
import org.mule.munit.plugins.coverage.path.PathParser;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;
import org.mule.processor.chain.SubflowInterceptingChainLifecycleWrapper;
import org.mule.util.NotificationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathBuilder {
    private MuleContext context;

    public PathBuilder(MuleContext muleContext) {
        this.context = muleContext;
    }

    public <T> Map buildGenericPathsMap(Class<T> clazzType, Function<Object, Boolean> shouldAdd, Function<Object, Map> reformatPaths) {
        HashMap pathsMap = new HashMap();
        Collection muleRegistryObjects = this.context.getRegistry().lookupObjects(clazzType);
        for (Object muleRegistryObject : muleRegistryObjects) {
            Object flowConstruct = PathBuilder.extractIfProxy(muleRegistryObject);
            if (!((Boolean)shouldAdd.apply(flowConstruct)).booleanValue()) continue;
            pathsMap.putAll((Map)reformatPaths.apply(flowConstruct));
        }
        return pathsMap;
    }

    public Map<MessageProcessor, String> buildFlowPathsMap() {
        return this.buildGenericPathsMap(AbstractPipeline.class, new Function<Object, Boolean>(){

            public Boolean apply(Object flowConstruct) {
                return !(flowConstruct instanceof MunitFlow);
            }
        }, new Function<Object, Map>(){

            public Map apply(Object flowConstruct) {
                Map paths = PathBuilder.this.buildPathsMap(flowConstruct);
                paths = PathFormatter.reformatFlowPaths(paths);
                return paths;
            }
        });
    }

    public Map<MessageProcessor, String> buildSubFlowPathsMap() {
        return this.buildGenericPathsMap(SubflowMessageProcessorChainFactoryBean.class, new Function<Object, Boolean>(){

            public Boolean apply(Object flowConstruct) {
                return true;
            }
        }, new Function<Object, Map>(){

            public Map apply(Object flowConstruct) {
                SubflowInterceptingChainLifecycleWrapper sf = PathBuilder.this.handleMunitSubFlowFromRegistry(flowConstruct);
                Map paths = PathBuilder.this.buildPathsMap(sf);
                paths = PathFormatter.reformatSubFlowPaths(paths);
                return PathBuilder.this.filterOutFlowRefInSubFlow2SubFlow(paths);
            }
        });
    }

    public Map<MessageProcessor, String> buildBatchPathsMap() {
        return this.buildGenericPathsMap(AbstractFlowConstruct.class, new Function<Object, Boolean>(){

            public Boolean apply(Object flowConstruct) {
                return "Batch".equals(((AbstractFlowConstruct)flowConstruct).getConstructType());
            }
        }, new Function<Object, Map>(){

            public Map apply(Object flowConstruct) {
                Map paths = PathBuilder.this.buildPathsMap(flowConstruct);
                paths = PathFormatter.reformatBatchPaths(paths);
                return paths;
            }
        });
    }

    private Map<MessageProcessor, String> buildPathsMap(Object flow) {
        String flowName = flow instanceof AbstractFlowConstruct ? ((AbstractFlowConstruct)flow).getName() : ((SubflowInterceptingChainLifecycleWrapper)flow).getName();
        DefaultMessageProcessorPathElement messageProcessorPathElement = this.buildMessageProcessorPathElement((MessageProcessorContainer)flow, flowName);
        return this.filterOutInvalidChoiceMessageProcessors(NotificationUtils.buildPaths((MessageProcessorPathElement)messageProcessorPathElement));
    }

    private DefaultMessageProcessorPathElement buildMessageProcessorPathElement(MessageProcessorContainer flow, String flowName) {
        DefaultMessageProcessorPathElement pipeLinePathElement = new DefaultMessageProcessorPathElement(null, flowName);
        flow.addMessageProcessorPathElements((MessageProcessorPathElement)pipeLinePathElement);
        return pipeLinePathElement;
    }

    private SubflowInterceptingChainLifecycleWrapper handleMunitSubFlowFromRegistry(Object subFlow) {
        try {
            SubflowInterceptingChainLifecycleWrapper sf = subFlow instanceof SubflowInterceptingChainLifecycleWrapper ? (SubflowInterceptingChainLifecycleWrapper)subFlow : (SubflowInterceptingChainLifecycleWrapper)((SubflowMessageProcessorChainFactoryBean)subFlow).getObject();
            return sf;
        }
        catch (Exception e) {
            throw new RuntimeException("MUnit Cobertura Plugin, there was an error trying to account for sub-flows.", e);
        }
    }

    private Map<MessageProcessor, String> filterOutFlowRefInSubFlow2SubFlow(Map<MessageProcessor, String> subFlowPaths) {
        HashMap<MessageProcessor, String> filteredPaths = new HashMap<MessageProcessor, String>();
        for (MessageProcessor k : subFlowPaths.keySet()) {
            String path = subFlowPaths.get(k);
            if (!PathParser.doesNotHaveFlowRefToSubFlow(path)) continue;
            filteredPaths.put(k, path);
        }
        return filteredPaths;
    }

    private Map<MessageProcessor, String> filterOutInvalidChoiceMessageProcessors(Map<MessageProcessor, String> messageProcessors) {
        HashMap<MessageProcessor, String> mpMap = new HashMap<MessageProcessor, String>();
        for (Map.Entry<MessageProcessor, String> mp : messageProcessors.entrySet()) {
            MessageProcessor actualMp = mp.getKey();
            if (InterceptingChainLifecycleWrapper.class.isAssignableFrom(actualMp.getClass())) {
                String chainName = ((InterceptingChainLifecycleWrapper)actualMp).getName();
                if (chainName.equals("(inner iterating chain) of null")) continue;
                mpMap.put(actualMp, mp.getValue());
                continue;
            }
            mpMap.put(actualMp, mp.getValue());
        }
        return mpMap;
    }

    public static Map<String, List<String>> buildFlowPathsMap(Set<String> paths) {
        HashMap<String, List<String>> flowsMap = new HashMap<String, List<String>>();
        for (String p : paths) {
            String flowName = PathParser.getFlowName(p);
            if (flowsMap.containsKey(flowName)) {
                ((List)flowsMap.get(flowName)).add(p);
                continue;
            }
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(p);
            flowsMap.put(flowName, pathList);
        }
        return flowsMap;
    }

    public static Set<String> filterPaths(Set<String> paths, Set<String> flowNamesToFilter) {
        HashSet<String> filteredPaths = new HashSet<String>();
        for (String path : paths) {
            String flowName = PathParser.getFlowName(path);
            if (flowNamesToFilter.contains(flowName)) continue;
            filteredPaths.add(path);
        }
        return filteredPaths;
    }

    public static Map<String, List<String>> buildApplicationFlowPathMap(Set<String> flows, Set<String> subFlows, Set<String> batches) {
        HashMap<String, List<String>> flowsMap = new HashMap<String, List<String>>();
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(flows));
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(subFlows));
        flowsMap.putAll(PathBuilder.buildFlowPathsMap(batches));
        return flowsMap;
    }

    public static Set<String> filterIgnoredFlows(Set<String> paths, Set<String> flowsToIgnore) {
        if (null != flowsToIgnore) {
            return PathBuilder.filterPaths(paths, flowsToIgnore);
        }
        return paths;
    }

    private static Object extractIfProxy(Object muleRegistryObject) {
        try {
            Class<?> proxyExtractorClass = Class.forName("org.mule.munit.common.util.ProxyExtractor");
            Method extractProxyMethod = proxyExtractorClass.getMethod("extractIfProxy", Object.class);
            return extractProxyMethod.invoke(null, muleRegistryObject);
        }
        catch (ClassNotFoundException e) {
            return muleRegistryObject;
        }
        catch (NoSuchMethodException e) {
            return muleRegistryObject;
        }
        catch (IllegalAccessException e) {
            return muleRegistryObject;
        }
        catch (InvocationTargetException e) {
            return muleRegistryObject;
        }
    }
}

