/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.path;

import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathParser {
    public static final String PROCESSORS_TOKEN = "processors";
    public static final String SUB_PROCESSORS_TOKEN = "subprocessors";
    public static final String EXCEPTION_TOKEN = "es";
    public static final String BATCH_INPUT_TOKEN = "input";
    public static final String BATCH_PROCESS_RECORD_TOKEN = "process-records";
    public static final String BATCH_ON_COMPLETE_TOKEN = "on-complete";
    public static final String SLASHES_THAT_ARE_NOT_PRECEDED_BY_BACKSLASH = "(?<!\\\\)/";

    public static String getFlowName(String path) {
        return PathParser.getTokens(path)[1];
    }

    public static String[] getTokens(String path) {
        return path.split(SLASHES_THAT_ARE_NOT_PRECEDED_BY_BACKSLASH);
    }

    public static boolean isGlobalCatchExceptionStrategy(List<String> segments) {
        return segments.size() >= 3 && EXCEPTION_TOKEN.equals(segments.get(3));
    }

    public static boolean doesNotHaveFlowRefToSubFlow(String path) {
        return StringUtils.countMatches((String)path, (String)SUB_PROCESSORS_TOKEN) <= 1;
    }

    public static int getSubProcessorsSecondAppearanceIdx(List<String> segments) {
        int counter = 0;
        for (int i = 0; i < segments.size(); ++i) {
            if (!segments.get(i).equals(SUB_PROCESSORS_TOKEN) || ++counter != 2) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsSubProcessorToken(List<String> segments) {
        return segments.contains(SUB_PROCESSORS_TOKEN);
    }

    public static int getSubProcessorTokenIndex(List<String> segments) {
        return segments.indexOf(SUB_PROCESSORS_TOKEN);
    }

    public static boolean hasParentPath(String path) {
        return path.contains(PROCESSORS_TOKEN) || path.contains(SUB_PROCESSORS_TOKEN) || path.contains(EXCEPTION_TOKEN);
    }

    public static String getParentPath(String path) {
        Object[] tokens;
        String parentPath = "";
        if (PathParser.hasParentPath(path) && (tokens = path.split(SLASHES_THAT_ARE_NOT_PRECEDED_BY_BACKSLASH)).length > 4) {
            parentPath = StringUtils.join((Object[])tokens, (String)"/", (int)0, (int)(tokens.length - 1));
        }
        return parentPath;
    }
}

