/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.core.CoverageModule;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

public class CoverageServerPlugin
implements MulePlugin,
DeploymentServiceAware,
DeploymentListener {
    public static final String COVERAGE_PORT_PROPERTY = "coverage.port";
    public static final String COVERAGE_SEND_ALL_LOCATIONS_PROPERTY = "coverage.send.all.locations";
    private transient Log logger = LogFactory.getLog(this.getClass());
    protected final String port = System.getProperty("coverage.port", null);
    protected CoverageModule coverageModule;
    protected DeploymentService deploymentService;

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        this.logger.info((Object)"Initialising coverage plugin...");
    }

    public void start() throws MuleException {
        this.logger.debug((Object)"Starting coverage plugin...");
    }

    public void stop() throws MuleException {
        this.logger.debug((Object)"Stopping coverage plugin...");
    }

    public void setWorkingDirectory(File file) {
    }

    public boolean isDisabledOnEnvironment() {
        return false;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        if (this.deploymentService != null) {
            this.deploymentService.addDeploymentListener((DeploymentListener)this);
        }
    }

    public void onUndeploymentStart(String artifactName) {
        if (this.shouldEnableCoverageServerPlugin()) {
            if (this.shouldSendAllLocations()) {
                this.logger.debug((Object)"Sending all locations report...");
                this.coverageModule.sendAllLocationReport(Integer.valueOf(this.port));
            } else {
                this.logger.debug((Object)"Sending covered locations report...");
                this.coverageModule.sendCoveredLocationsReport(Integer.valueOf(this.port));
            }
            this.logger.debug((Object)"Coverage location report sent");
        }
    }

    public void onMuleContextCreated(String artifactName, MuleContext context, CustomizationService customizationService) {
        if (this.shouldEnableCoverageServerPlugin() && this.coverageModule == null) {
            this.logger.debug((Object)"Coverage Server plugin enabled. Registering interceptor");
            this.coverageModule = new CoverageModule(context.getProcessorInterceptorManager());
        }
    }

    public void onMuleContextInitialised(String artifactName, MuleContext context) {
        if (this.coverageModule != null) {
            this.coverageModule.setComponentLocator(context.getConfigurationComponentLocator());
        }
    }

    private boolean shouldEnableCoverageServerPlugin() {
        return StringUtils.isNotBlank((CharSequence)this.port) && NumberUtils.isDigits((String)this.port);
    }

    private boolean shouldSendAllLocations() {
        return Boolean.valueOf(System.getProperty(COVERAGE_SEND_ALL_LOCATIONS_PROPERTY, "false"));
    }
}

