/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.core.LocationAccumulator;
import org.mule.munit.plugins.coverage.core.interception.ComponentLocationFilter;
import org.mule.munit.plugins.coverage.core.interception.CoverageProcessorInterceptor;
import org.mule.munit.plugins.coverage.core.interception.CoverageProcessorInterceptorFactory;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.server.CoverageLocations;
import org.mule.munit.plugins.coverage.server.CoverageServerClient;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.core.api.interception.ProcessorInterceptorProvider;

public class CoverageModule {
    private transient Log logger = LogFactory.getLog(this.getClass());
    protected ConfigurationComponentLocator componentLocator;
    protected ProcessorInterceptorProvider processorInterceptorProvider;
    protected LocationAccumulator locationAccumulator;

    public CoverageModule(ProcessorInterceptorProvider processorInterceptorProvider) {
        Preconditions.checkNotNull((Object)processorInterceptorProvider, (Object)"The interceptor provider must not be null");
        this.processorInterceptorProvider = processorInterceptorProvider;
        this.locationAccumulator = new LocationAccumulator();
        this.registerInterceptorFactory();
    }

    public void setComponentLocator(ConfigurationComponentLocator componentLocator) {
        Preconditions.checkNotNull((Object)componentLocator, (Object)"The component location provider must not be null");
        this.componentLocator = componentLocator;
    }

    public LocationAccumulator getLocationAccumulator() {
        return this.locationAccumulator;
    }

    public void sendCoveredLocationsReport(Integer port) {
        CoverageLocations report = new CoverageLocations(this.locationAccumulator.getCoverageLocations());
        this.sendReport(port, report);
    }

    public void sendAllLocationReport(Integer port) {
        Preconditions.checkArgument((this.componentLocator != null ? 1 : 0) != 0, (Object)"The componentLocator hasn't been provided.");
        Set<CoverageComponentLocation> componentLocations = this.componentLocator.findAll().stream().filter(cl -> ComponentLocationFilter.isRepresentativeForCoverage(cl.getLocation())).map(cl -> CoverageComponentLocation.fromComponentLocation(cl.getLocation())).collect(Collectors.toSet());
        CoverageLocations report = new CoverageLocations(componentLocations);
        report.setAllLocations(true);
        this.sendReport(port, report);
    }

    private void registerInterceptorFactory() {
        this.logger.debug((Object)("Adding " + CoverageProcessorInterceptor.class.getName() + " to processor interceptor manager"));
        this.processorInterceptorProvider.addInterceptorFactory((ProcessorInterceptorFactory)new CoverageProcessorInterceptorFactory(this.locationAccumulator));
    }

    protected void sendReport(Integer port, CoverageLocations report) {
        Preconditions.checkNotNull((Object)port, (Object)"The port must not be null");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"The port must be a positive number");
        new CoverageServerClient(port).sendCoveredLocations(report);
    }
}

