/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.interception;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;

public class ComponentLocationFilter {
    private static final List<String> NON_INTERCEPTABLE_NAMESPACES = Arrays.asList("munit", "munit-tools");

    public static boolean isRepresentativeForCoverage(ComponentLocation location) {
        return ComponentLocationFilter.shouldIntercept(location);
    }

    public static boolean shouldIntercept(ComponentLocation location) {
        if (ComponentLocationFilter.isLocationInsideMunitTest(location).booleanValue()) {
            return false;
        }
        TypedComponentIdentifier identifier = location.getComponentIdentifier();
        if (NON_INTERCEPTABLE_NAMESPACES.contains(identifier.getIdentifier().getNamespace())) {
            return false;
        }
        return TypedComponentIdentifier.ComponentType.PROCESSOR.equals((Object)identifier.getType()) || TypedComponentIdentifier.ComponentType.OPERATION.equals((Object)identifier.getType()) || TypedComponentIdentifier.ComponentType.INTERCEPTING.equals((Object)identifier.getType());
    }

    private static Boolean isLocationInsideMunitTest(ComponentLocation location) {
        Optional partIdentifier = ((LocationPart)location.getParts().get(0)).getPartIdentifier();
        if (partIdentifier.isPresent() && "munit".equals(((TypedComponentIdentifier)partIdentifier.get()).getIdentifier().getNamespace())) {
            return true;
        }
        return false;
    }
}

