/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.interception;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.core.LocationAccumulator;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;

public class CoverageProcessorInterceptor
implements ProcessorInterceptor {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private LocationAccumulator locationAccumulator;

    public CoverageProcessorInterceptor(LocationAccumulator locationAccumulator) {
        Preconditions.checkNotNull((Object)locationAccumulator, (Object)"The reporter must not be null");
        this.locationAccumulator = locationAccumulator;
    }

    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
        this.logger.debug((Object)("About to register execution of: " + this.locationToStringLog(location)));
        this.locationAccumulator.addCoveredLocation(location);
        return action.proceed();
    }

    public LocationAccumulator getLocationAccumulator() {
        return this.locationAccumulator;
    }

    private String locationToStringLog(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier() + " in " + location.getFileName().orElse(" ? ") + "[line: " + location.getLineInFile().orElse(-1) + "].";
    }
}

