/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.server.CoverageLocationsAccumulator;
import org.mule.munit.plugins.coverage.server.CoverageMessageParser;

public class CoverageServer
implements Runnable {
    private static final int SOCKET_TIMEOUT_MILLIS = 1800000;
    private transient Log log = LogFactory.getLog(this.getClass());
    private Integer port;
    private Boolean running = false;
    private Boolean keepRunning = true;
    private CoverageLocationsAccumulator coverageLocationsAccumulator;

    public CoverageServer(Integer port, CoverageLocationsAccumulator coverageLocationsAccumulator) {
        Preconditions.checkNotNull((Object)port, (Object)"The port can not be null.");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"The port must be a positive number.");
        Preconditions.checkNotNull((Object)coverageLocationsAccumulator, (Object)"The report accumulator must not be null.");
        this.port = port;
        this.coverageLocationsAccumulator = coverageLocationsAccumulator;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void launch() {
        if (this.running.booleanValue()) {
            throw new RuntimeException("The Coverage server is already running it can not be started again.");
        }
        new Thread(this).start();
    }

    public synchronized void shutDown() {
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Coverage Server starting...");
        this.running = true;
        this.keepRunning = true;
        ServerSocket providerSocket = null;
        try {
            providerSocket = new ServerSocket(this.port, 10);
            providerSocket.setSoTimeout(1800000);
            this.log.info((Object)("Waiting for coverage client connection in port [" + this.port + "]..."));
            do {
                Socket connection = providerSocket.accept();
                this.log.info((Object)("Coverage client connection received from " + connection.getInetAddress().getHostName() + " - " + this.keepRunning));
                CoverageMessageParser parser = new CoverageMessageParser(new ObjectInputStream(connection.getInputStream()), this.coverageLocationsAccumulator);
                new Thread(parser).run();
            } while (this.keepRunning.booleanValue());
        }
        catch (SocketTimeoutException timeoutException) {
            this.log.warn((Object)"Coverage Server time out");
            if (this.keepRunning.booleanValue()) {
                this.log.error((Object)("Coverage Server connection timeout after " + String.valueOf(1800000) + " milliseconds"));
            }
        }
        catch (IOException ioException) {
            this.log.error((Object)("Failed to start Coverage Server in port " + this.port));
        }
        finally {
            try {
                this.log.debug((Object)("Shutting down coverage server running in port [" + this.port + "]..."));
                this.running = false;
                this.keepRunning = false;
                if (null != providerSocket) {
                    providerSocket.close();
                }
                this.log.debug((Object)"Coverage server shutdown");
            }
            catch (IOException ioException) {
                this.log.debug((Object)"Coverage Server error during shut down.");
            }
        }
    }
}

