/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;

public class ApplicationCoverageReport {
    private Double branchCoverage;
    private List<MuleResource> resources = new ArrayList<MuleResource>();

    public ApplicationCoverageReport() {
    }

    public ApplicationCoverageReport(List<MuleResource> resources) {
        Preconditions.checkNotNull(resources, (Object)"The resources list must not be null.");
        this.resources = resources;
        this.setResourcesWeight();
    }

    public List<MuleResource> getResources() {
        return this.resources;
    }

    public Double getCoverage() {
        Integer totalMpCount = this.getApplicationMessageProcessorCount();
        Integer coveredMpCount = this.getApplicationCoveredMessageProcessorCount();
        if (totalMpCount > 0) {
            return (double)coveredMpCount.intValue() * 100.0 / (double)totalMpCount.intValue();
        }
        return -1.0;
    }

    public void setBranchCoverage(Double branchCoverage) {
        this.branchCoverage = branchCoverage;
    }

    public Double getBranchCoverage() {
        if (this.branchCoverage == null) {
            return -1.0;
        }
        return this.branchCoverage;
    }

    public Integer getApplicationFlowCount() {
        Integer applicationFlowCount = 0;
        for (MuleResource mr : this.resources) {
            applicationFlowCount = applicationFlowCount + mr.getFlows().size();
        }
        return applicationFlowCount;
    }

    public Integer getApplicationMessageProcessorCount() {
        Integer applicationMpCount = 0;
        for (MuleResource mr : this.resources) {
            for (MuleFlow mf : mr.getFlows()) {
                applicationMpCount = applicationMpCount + mf.getLocations().size();
            }
        }
        return applicationMpCount;
    }

    public Integer getApplicationCoveredMessageProcessorCount() {
        Integer applicationMpCount = 0;
        for (MuleResource mr : this.resources) {
            for (MuleFlow mf : mr.getFlows()) {
                applicationMpCount = applicationMpCount + mf.getCoveredLocations().size();
            }
        }
        return applicationMpCount;
    }

    private void setResourcesWeight() {
        Integer totalMpCount = this.getApplicationMessageProcessorCount();
        for (MuleResource mr : this.resources) {
            Double weight = totalMpCount == 0 ? 0.0 : (double)mr.getMessageProcessorCount().intValue() * 100.0 / (double)totalMpCount.intValue();
            mr.setWeight(weight);
        }
    }
}

