/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.report.printer;

import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_AsciiTableRenderer;
import de.vandermeer.asciitable.v2.render.V2_Width;
import de.vandermeer.asciitable.v2.render.WidthLongestLine;
import de.vandermeer.asciitable.v2.themes.V2_E_TableThemes;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import org.mule.munit.plugins.coverage.report.model.ApplicationCoverageReport;
import org.mule.munit.plugins.coverage.report.model.MuleFlow;
import org.mule.munit.plugins.coverage.report.model.MuleResource;
import org.mule.munit.plugins.coverage.report.printer.CoverageReportPrinter;

public abstract class ConsolePrinter
implements CoverageReportPrinter {
    public static final String PRINTER_NAME = "Console";
    private static final char[] TABLE_ALIGNMENT = new char[]{'l', 'l', 'c', 'c', 'c'};

    @Override
    public String getPrinterName() {
        return PRINTER_NAME;
    }

    @Override
    public void printReport(ApplicationCoverageReport report) {
        this.log("===============================================================================");
        this.log("\t\t\t\tMUnit Coverage Report");
        this.log("===============================================================================");
        this.log("");
        V2_AsciiTableRenderer flowTableRenderer = new V2_AsciiTableRenderer();
        flowTableRenderer.setWidth((V2_Width)new WidthLongestLine());
        V2_AsciiTableRenderer resourceRowRenderer = new V2_AsciiTableRenderer();
        resourceRowRenderer.setWidth((V2_Width)new WidthLongestLine());
        resourceRowRenderer.setTheme(V2_E_TableThemes.UTF_DOUBLE.get());
        for (MuleResource mr : report.getResources()) {
            String resourceLine = mr.getCoverage() != -1.0 ? "Resource File: " + mr.getName() + " - Containers: " + mr.getFlows().size() + " - Weight: " + this.formatDecimals(mr.getWeight()) + " -  Coverage: " + this.formatDecimals(mr.getCoverage()) + "%" : "Resource File: " + mr.getName() + " - Containers: " + mr.getFlows().size() + " - Weight: " + this.formatDecimals(mr.getWeight()) + " -  Coverage: N/A";
            this.renderResourceRow(resourceRowRenderer, resourceLine);
            this.renderContainerTable(flowTableRenderer, mr);
        }
        this.log("");
        this.log("===============================================================================");
        this.log("\t\t\t\t\tSummary");
        this.log("===============================================================================");
        this.log("  * Covered Processors: " + report.getApplicationCoveredMessageProcessorCount());
        this.log("  * Total Processors:   " + report.getApplicationMessageProcessorCount());
        this.log("  * Containers:         " + report.getApplicationFlowCount());
        this.log("  * Resources:          " + report.getResources().size());
        this.log("===============================================================================");
        if (report.getApplicationFlowCount() > 0) {
            this.log("\t\t\t\t** Application Coverage: " + this.formatDecimals(report.getCoverage()) + "% **");
        } else {
            this.log("\t\t\t\t** Application Coverage: N/A **");
        }
        this.log("===============================================================================");
    }

    protected abstract void log(String var1);

    private void renderContainerTable(V2_AsciiTableRenderer flowTableRenderer, MuleResource mr) {
        Scanner flowCoverageTableScanner = this.getContainerCoverageTable(mr.getFlows(), flowTableRenderer);
        while (flowCoverageTableScanner.hasNextLine()) {
            this.log(flowCoverageTableScanner.nextLine());
        }
    }

    private void renderResourceRow(V2_AsciiTableRenderer resourceRowRenderer, String resourceLine) {
        V2_AsciiTable resourceRow = new V2_AsciiTable();
        resourceRow.addRule();
        resourceRow.addRow(new Object[]{resourceLine});
        resourceRow.addRule();
        Scanner resourceRowScanner = new Scanner(resourceRowRenderer.render(resourceRow).toString());
        while (resourceRowScanner.hasNextLine()) {
            this.log(resourceRowScanner.nextLine());
        }
    }

    private Scanner getContainerCoverageTable(List<MuleFlow> flows, V2_AsciiTableRenderer renderer) {
        V2_AsciiTable containerTable = new V2_AsciiTable();
        containerTable.addRule();
        containerTable.addRow(new Object[]{"Name", "Type", "Covered (P)", "Total (P)", "Coverage"}).setAlignment(TABLE_ALIGNMENT);
        containerTable.addRule();
        for (MuleFlow mf : flows) {
            containerTable.addRow(new Object[]{mf.getName(), mf.getPrintableType(), mf.getCoveredLocations().size(), mf.getLocations().size(), this.formatDecimals(mf.getCoverage()) + "%"}).setAlignment(TABLE_ALIGNMENT);
        }
        containerTable.addRule();
        return new Scanner(renderer.render(containerTable).toString());
    }

    private String formatDecimals(Double number) {
        return String.format(Locale.ENGLISH, "%.2f", number);
    }
}

