/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.munit.plugins.coverage.core.CoverageModule;
import org.mule.munit.plugins.coverage.core.interception.CoverageProcessorInterceptorFactory;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

public class CoverageServerPlugin
implements MulePlugin,
DeploymentServiceAware,
DeploymentListener {
    public static final String COVERAGE_PORT_PROPERTY = "coverage.port";
    private transient Log logger = LogFactory.getLog(this.getClass());
    protected final String port = System.getProperty("coverage.port", null);
    protected CoverageModule coverageModule;
    protected DeploymentService deploymentService;

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        this.logger.info((Object)"Initialising coverage plugin...");
    }

    public void start() throws MuleException {
        this.logger.debug((Object)"Starting coverage plugin...");
    }

    public void stop() throws MuleException {
        this.logger.debug((Object)"Stopping coverage plugin...");
    }

    public void setWorkingDirectory(File file) {
    }

    public boolean isDisabledOnEnvironment() {
        return false;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        if (this.deploymentService != null) {
            this.deploymentService.addDeploymentListener((DeploymentListener)this);
        }
    }

    public void onUndeploymentStart(String artifactName) {
        if (this.shouldEnableCoverageServerPlugin()) {
            this.logger.debug((Object)"Sending covered locations report...");
            this.coverageModule.sendCoveredLocationsReport(Integer.valueOf(this.port));
            this.logger.debug((Object)"Sending all locations report...");
            this.coverageModule.sendAllLocationReport(Integer.valueOf(this.port));
            this.logger.debug((Object)"Coverage location reports sent");
        }
    }

    public void onArtifactCreated(String artifactName, CustomizationService customizationService) {
        if (this.shouldEnableCoverageServerPlugin() && this.coverageModule == null) {
            this.logger.debug((Object)"Coverage Server plugin enabled. Registering interceptor");
            this.coverageModule = new CoverageModule();
            CoverageProcessorInterceptorFactory interceptorFactory = new CoverageProcessorInterceptorFactory(this.coverageModule.getLocationAccumulator());
            customizationService.registerCustomServiceImpl("_munitCoverageProcessorInterceptorFactory", (Object)interceptorFactory);
        }
    }

    public void onArtifactInitialised(String artifactName, Registry registry) {
        if (this.coverageModule != null) {
            ConfigurationComponentLocator locator = (ConfigurationComponentLocator)registry.lookupByName("_muleConfigurationComponentLocator").get();
            this.coverageModule.setComponentLocator(locator);
        }
    }

    private boolean shouldEnableCoverageServerPlugin() {
        return StringUtils.isNotBlank((CharSequence)this.port) && NumberUtils.isDigits((String)this.port);
    }
}

