/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.model;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;

public class CoverageComponentIdentifier
implements ComponentIdentifier,
Serializable {
    private static final long serialVersionUID = -7904681927277956932L;
    private String namespace;
    private String name;

    public CoverageComponentIdentifier(String namespace, String name) {
        Preconditions.checkArgument((namespace != null && !namespace.trim().isEmpty() ? 1 : 0) != 0, (Object)"Prefix URI must be not blank");
        Preconditions.checkArgument((name != null && !name.trim().isEmpty() ? 1 : 0) != 0, (Object)"Name must be not blank");
        this.namespace = namespace;
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageComponentIdentifier that = (CoverageComponentIdentifier)o;
        if (!this.getNamespace().equalsIgnoreCase(that.getNamespace())) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        int result = this.getNamespace().toLowerCase().hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public String toString() {
        return this.getNamespace().equals("mule") ? this.getName() : this.getNamespace() + ":" + this.getName();
    }

    public static CoverageComponentIdentifier fromComponentIdentifier(ComponentIdentifier identifier) {
        return new CoverageComponentIdentifier(identifier.getNamespace(), identifier.getName());
    }

    public static CoverageComponentIdentifier parseComponentIdentifier(String componentIdentifier) {
        String identifier;
        String namespace;
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)componentIdentifier) ? 1 : 0) != 0, (Object)"identifier cannot be an empty string or null");
        String[] values = componentIdentifier.split(":");
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = "mule";
            identifier = values[0];
        }
        return new CoverageComponentIdentifier(namespace, identifier);
    }
}

