/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.model;

import org.apache.commons.lang3.Validate;

/**
 * <p>
 * A model that represents the coverage limits
 * </p>
 * 
 * @author Mulesoft Inc.
 * @since 2.1.0
 */
public class CoverageLimits {

  private Double requiredApplicationCoverage = -1.0;
  private Double requiredResourceCoverage = -1.0;
  private Double requiredFlowCoverage = -1.0;

  public CoverageLimits() {

  }

  public CoverageLimits(Double requiredApplicationCoverage, Double requiredResourceCoverage, Double requiredFlowCoverage) {
    Validate.notNull(requiredApplicationCoverage, "Required Application Coverage cannot be null");
    Validate.notNull(requiredResourceCoverage, "Required Resource Coverage cannot be null");
    Validate.notNull(requiredFlowCoverage, "Required Flow Coverage cannot be null");
    this.requiredApplicationCoverage = requiredApplicationCoverage;
    this.requiredResourceCoverage = requiredResourceCoverage;
    this.requiredFlowCoverage = requiredFlowCoverage;
  }

  public Double getRequiredApplicationCoverage() {
    return requiredApplicationCoverage;
  }

  public Double getRequiredResourceCoverage() {
    return requiredResourceCoverage;
  }

  public Double getRequiredFlowCoverage() {
    return requiredFlowCoverage;
  }
}
