/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.printer.model.sonar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * Model to represent the source file in the xml Sonar report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
@XStreamAlias(value = "file")
public class SonarFile {

  @XStreamAsAttribute
  private String path;

  @XStreamImplicit
  private List<SonarLineToCover> linesToCover = new ArrayList<>();

  public SonarFile(String path) {
    this.path = path;
  }

  public void addLineToCover(SonarLineToCover lineToCover) {
    this.linesToCover.add(lineToCover);
  }

  public List<SonarLineToCover> getLinesToCover() {
    return linesToCover;
  }
}
