/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.model;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static org.apache.commons.lang3.StringUtils.isNoneEmpty;

/**
 * <p>
 * A model that represents a Mule Location
 * </p>
 * 
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class MuleLocation {

  private String path;
  private Integer lineNumber;

  public MuleLocation(String path, Integer lineNumber) {
    checkArgument(isNoneEmpty(path), "The path must not be null nor empty.");
    checkNotNull(lineNumber, "The line number must not be null.");

    this.path = path;
    this.lineNumber = lineNumber;
  }

  public String getPath() {
    return path;
  }

  public Integer getLineNumber() {
    return lineNumber;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MuleLocation)) {
      return false;
    }
    MuleLocation that = (MuleLocation) o;

    if (!path.equals(that.path)) {
      return false;
    }
    return lineNumber.equals(that.lineNumber);
  }

  @Override
  public int hashCode() {
    int result = path.hashCode();
    result = 31 * result + lineNumber.hashCode();
    return result;
  }
}
