/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.report.printer.model.sonar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * Model to represent the coverage in the xml Sonar report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
@XStreamAlias(value = "coverage")
public class SonarCoverage {

  @XStreamAsAttribute
  private final int version = 1;

  @XStreamImplicit
  private List<SonarFile> files = new ArrayList<>();

  public void addFile(SonarFile sonarFile) {
    files.add(sonarFile);
  }

  public List<SonarFile> getFiles() {
    return files;
  }
}
