/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.core.interception;

import static com.google.common.base.Preconditions.checkNotNull;
import static org.mule.munit.plugins.coverage.core.interception.ComponentLocationFilter.shouldIntercept;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.mule.munit.plugins.coverage.core.LocationAccumulator;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;

/**
 * The goal of this class is to define if a processor should be intercepted. If so creates a ProcessorInterceptor
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class CoverageProcessorInterceptorFactory implements ProcessorInterceptorFactory {

  public static final String MUNIT_COVERAGE_PROCESSOR_INTERCEPTOR_FACTORY_ID = "_munitCoverageProcessorInterceptorFactory";

  private transient Log logger = LogFactory.getLog(this.getClass());

  private LocationAccumulator locationAccumulator;

  public CoverageProcessorInterceptorFactory(LocationAccumulator locationAccumulator) {
    checkNotNull(locationAccumulator, "The reporter must not be null");
    this.locationAccumulator = locationAccumulator;
  }

  @Override
  public ProcessorInterceptor get() {
    return new CoverageProcessorInterceptor(locationAccumulator);
  }

  @Override
  public boolean intercept(ComponentLocation location) {
    logger.debug("Should coverage intercept: " + locationToStringLog(location));

    return shouldIntercept(location);
  }

  private String locationToStringLog(ComponentLocation location) {
    return location.getComponentIdentifier().getIdentifier()
        + " in "
        + location.getFileName().orElse(" ? ")
        + "[line: " + location.getLineInFile().orElse(-1) + "].";
  }

}
