/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.plugins.coverage.CoverageServerPlugin;
import org.mule.munit.plugins.coverage.core.CoverageModule;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;

public class CoverageServerPluginTest {
    private Registry muleRegistryMock;
    private DeploymentService deploymentServiceMock;
    private CoverageModule coverageModuleMock;
    private CustomizationService customizationServiceMock;
    private ConfigurationComponentLocator componentLocatorMock;

    @Before
    public void setUp() {
        this.muleRegistryMock = (Registry)Mockito.mock(Registry.class);
        this.customizationServiceMock = (CustomizationService)Mockito.mock(CustomizationService.class);
        this.componentLocatorMock = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class);
        this.deploymentServiceMock = (DeploymentService)Mockito.mock(DeploymentService.class);
        this.coverageModuleMock = (CoverageModule)Mockito.mock(CoverageModule.class);
        Mockito.when((Object)this.muleRegistryMock.lookupByName("_muleConfigurationComponentLocator")).thenReturn(Optional.of(this.componentLocatorMock));
    }

    @Test
    public void onArtifactCreated() {
        System.setProperty("coverage.port", "6666");
        CoverageServerPlugin coverageServerPlugin = new CoverageServerPlugin();
        coverageServerPlugin.onArtifactCreated("", this.customizationServiceMock);
        System.clearProperty("coverage.port");
        Assert.assertThat((Object)coverageServerPlugin.coverageModule, (Matcher)org.hamcrest.Matchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void onArtifactCreatedMoreThanOnceCoverageModuleShouldBeTheSame() {
        System.setProperty("coverage.port", "6666");
        CoverageServerPlugin coverageServerPlugin = new CoverageServerPlugin();
        coverageServerPlugin.onArtifactCreated("", this.customizationServiceMock);
        CoverageModule firstCoverageModule = coverageServerPlugin.coverageModule;
        coverageServerPlugin.onArtifactCreated("", this.customizationServiceMock);
        CoverageModule secondCoverageModule = coverageServerPlugin.coverageModule;
        System.clearProperty("coverage.port");
        Assert.assertThat((Object)firstCoverageModule, (Matcher)org.hamcrest.Matchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)secondCoverageModule, (Matcher)org.hamcrest.Matchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)firstCoverageModule, (Matcher)org.hamcrest.Matchers.equalTo((Object)secondCoverageModule));
    }

    @Test
    public void onMuleContextCreated() {
        System.setProperty("coverage.port", "6666");
        CoverageServerPlugin coverageServerPlugin = new CoverageServerPlugin();
        coverageServerPlugin.onArtifactCreated("", this.customizationServiceMock);
        coverageServerPlugin.onArtifactInitialised("", this.muleRegistryMock);
        System.clearProperty("coverage.port");
        Assert.assertThat((Object)coverageServerPlugin.coverageModule, (Matcher)org.hamcrest.Matchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)coverageServerPlugin.coverageModule.getComponentLocator(), (Matcher)org.hamcrest.Matchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void setDeploymentService() {
        CoverageServerPlugin coverageServerPlugin = new CoverageServerPlugin();
        coverageServerPlugin.setDeploymentService(this.deploymentServiceMock);
        ((DeploymentService)Mockito.verify((Object)this.deploymentServiceMock, (VerificationMode)Mockito.times((int)1))).addDeploymentListener((DeploymentListener)coverageServerPlugin);
    }

    @Test
    public void onUndeploymentStartSendCoveredLocations() throws MuleException {
        System.setProperty("coverage.port", "6666");
        CoverageServerPlugin coverageServerPlugin = new CoverageServerPlugin();
        coverageServerPlugin.coverageModule = this.coverageModuleMock;
        coverageServerPlugin.onUndeploymentStart("");
        System.clearProperty("coverage.port");
        ((CoverageModule)Mockito.verify((Object)this.coverageModuleMock, (VerificationMode)Mockito.times((int)1))).sendCoveredLocationsReport((Integer)Matchers.any());
        ((CoverageModule)Mockito.verify((Object)this.coverageModuleMock, (VerificationMode)Mockito.times((int)1))).sendAllLocationReport((Integer)Matchers.any());
    }
}

