/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.munit.plugins.coverage.core.CoverageModule;
import org.mule.munit.plugins.coverage.core.LocationAccumulator;
import org.mule.munit.plugins.coverage.server.CoverageLocations;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;

public class CoverageModuleTest {
    protected LocationAccumulator locationAccumulatorMock;
    private ConfigurationComponentLocator componentLocatorMock;

    @Before
    public void setUp() {
        this.locationAccumulatorMock = (LocationAccumulator)Mockito.mock(LocationAccumulator.class);
        this.componentLocatorMock = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class);
    }

    @Test(expected=NullPointerException.class)
    public void validateCreationNullComponentLocation() {
        CoverageModule coverageModule = new CoverageModule();
        coverageModule.setComponentLocator(null);
    }

    @Test
    public void sendCoveredLocationsReport() {
        Integer port = 6666;
        CoverageModule coverageModuleMock = (CoverageModule)Mockito.mock(CoverageModule.class);
        coverageModuleMock.locationAccumulator = this.locationAccumulatorMock;
        ((CoverageModule)Mockito.doCallRealMethod().when((Object)coverageModuleMock)).sendCoveredLocationsReport(port);
        coverageModuleMock.sendCoveredLocationsReport(port);
        ((LocationAccumulator)Mockito.verify((Object)this.locationAccumulatorMock, (VerificationMode)Mockito.times((int)1))).getCoverageLocations();
        ArgumentCaptor coverageLocationsArgumentCaptor = ArgumentCaptor.forClass(CoverageLocations.class);
        ((CoverageModule)Mockito.verify((Object)coverageModuleMock, (VerificationMode)Mockito.times((int)1))).sendReport((Integer)Matchers.eq((Object)port), (CoverageLocations)coverageLocationsArgumentCaptor.capture());
        MatcherAssert.assertThat((Object)((CoverageLocations)coverageLocationsArgumentCaptor.getValue()).isAllLocations(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void sendAllLocationsReport() {
        Integer port = 6666;
        CoverageModule coverageModuleMock = (CoverageModule)Mockito.mock(CoverageModule.class);
        coverageModuleMock.componentLocator = this.componentLocatorMock;
        ((CoverageModule)Mockito.doCallRealMethod().when((Object)coverageModuleMock)).sendAllLocationReport(port);
        coverageModuleMock.sendAllLocationReport(port);
        ((ConfigurationComponentLocator)Mockito.verify((Object)this.componentLocatorMock, (VerificationMode)Mockito.times((int)1))).findAllLocations();
        ArgumentCaptor coverageLocationsArgumentCaptor = ArgumentCaptor.forClass(CoverageLocations.class);
        ((CoverageModule)Mockito.verify((Object)coverageModuleMock, (VerificationMode)Mockito.times((int)1))).sendReport((Integer)Matchers.eq((Object)port), (CoverageLocations)coverageLocationsArgumentCaptor.capture());
        MatcherAssert.assertThat((Object)((CoverageLocations)coverageLocationsArgumentCaptor.getValue()).isAllLocations(), (Matcher)Is.is((Object)true));
    }
}

