/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.interception;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.munit.plugins.coverage.core.interception.ComponentLocationFilter;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ComponentLocationFilterTest {
    @Before
    public void setUp() {
    }

    @Test
    public void validateInterceptMunitNameSapce() {
        ComponentLocation location = this.buildComponentLocation("munit", "logger", TypedComponentIdentifier.ComponentType.ROUTER);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptMunitToolsNameSapce() {
        ComponentLocation location = this.buildComponentLocation("munit-tools", "logger", TypedComponentIdentifier.ComponentType.OPERATION);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptFlow() {
        ComponentLocation location = this.buildComponentLocation("fake", "processor", TypedComponentIdentifier.ComponentType.FLOW);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptSource() {
        ComponentLocation location = this.buildComponentLocation("fake", "processor", TypedComponentIdentifier.ComponentType.SOURCE);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptScope() {
        ComponentLocation location = this.buildComponentLocation("fake", "processor", TypedComponentIdentifier.ComponentType.SCOPE);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptRouter() {
        ComponentLocation location = this.buildComponentLocation("fake", "processor", TypedComponentIdentifier.ComponentType.ROUTER);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptErrorHandler() {
        ComponentLocation location = this.buildComponentLocation("fake", "processor", TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptOnError() {
        ComponentLocation location = this.buildComponentLocation("fake", "processor", TypedComponentIdentifier.ComponentType.ON_ERROR);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    @Test
    public void validateInterceptOperation() {
        ComponentLocation location = this.buildComponentLocation("fake", "opeartion", TypedComponentIdentifier.ComponentType.OPERATION);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateInterceptIntercepting() {
        ComponentLocation location = this.buildComponentLocation("fake", "processor", TypedComponentIdentifier.ComponentType.INTERCEPTING);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateLocationInsideMunitScope() {
        ComponentLocation location = this.buildComponentLocationInsideMunitScope("fake", "processor", TypedComponentIdentifier.ComponentType.OPERATION);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)ComponentLocationFilter.shouldIntercept((ComponentLocation)location), (Matcher)Is.is((Object)false));
    }

    private ComponentLocation buildComponentLocation(String namesapce, String name, TypedComponentIdentifier.ComponentType type) {
        String identifier = namesapce + ":" + name;
        TypedComponentIdentifier typedComponentIdentifier = TypedComponentIdentifier.builder().type(type).identifier(ComponentIdentifier.buildFromStringRepresentation((String)identifier)).build();
        DefaultComponentLocation location = new DefaultComponentLocation(Optional.of(identifier), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart(name, Optional.of(typedComponentIdentifier), Optional.empty(), Optional.empty())));
        return location;
    }

    private ComponentLocation buildComponentLocationInsideMunitScope(String namesapce, String name, TypedComponentIdentifier.ComponentType type) {
        String identifier = namesapce + ":" + name;
        ArrayList<DefaultComponentLocation.DefaultLocationPart> parts = new ArrayList<DefaultComponentLocation.DefaultLocationPart>();
        TypedComponentIdentifier testComponentIdentifier = TypedComponentIdentifier.builder().type(TypedComponentIdentifier.ComponentType.ROUTER).identifier(ComponentIdentifier.buildFromStringRepresentation((String)"munit:test")).build();
        parts.add(new DefaultComponentLocation.DefaultLocationPart("test", Optional.of(testComponentIdentifier), Optional.empty(), Optional.empty()));
        TypedComponentIdentifier typedComponentIdentifier = TypedComponentIdentifier.builder().type(type).identifier(ComponentIdentifier.buildFromStringRepresentation((String)identifier)).build();
        parts.add(new DefaultComponentLocation.DefaultLocationPart(name, Optional.of(typedComponentIdentifier), Optional.empty(), Optional.empty()));
        DefaultComponentLocation location = new DefaultComponentLocation(Optional.of(identifier), parts);
        return location;
    }
}

