/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.interception;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.munit.plugins.coverage.core.LocationAccumulator;
import org.mule.munit.plugins.coverage.core.interception.CoverageProcessorInterceptor;
import org.mule.munit.plugins.coverage.core.interception.CoverageProcessorInterceptorFactory;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class CoverageProcessorInterceptorFactoryTest {
    private CoverageProcessorInterceptorFactory factory;
    private LocationAccumulator locationAccumulatorMock;

    @Before
    public void setUp() {
        this.locationAccumulatorMock = (LocationAccumulator)Mockito.mock(LocationAccumulator.class);
        this.factory = new CoverageProcessorInterceptorFactory(this.locationAccumulatorMock);
    }

    @Test(expected=NullPointerException.class)
    public void validateNullReporter() {
        new CoverageProcessorInterceptorFactory(null);
    }

    @Test
    public void validateGet() {
        CoverageProcessorInterceptor interceptor = (CoverageProcessorInterceptor)this.factory.get();
        MatcherAssert.assertThat((Object)interceptor.getLocationAccumulator(), (Matcher)Is.is((Object)this.locationAccumulatorMock));
    }

    @Test
    public void validateInterceptOperation() {
        ComponentLocation location = this.buildComponentLocation("mule", "logger", TypedComponentIdentifier.ComponentType.OPERATION);
        MatcherAssert.assertThat((String)"The location should have been intercepted ", (Object)this.factory.intercept(location), (Matcher)Is.is((Object)true));
    }

    private ComponentLocation buildComponentLocation(String namesapce, String name, TypedComponentIdentifier.ComponentType type) {
        String identifier = namesapce + ":" + name;
        TypedComponentIdentifier typedComponentIdentifier = TypedComponentIdentifier.builder().type(type).identifier(ComponentIdentifier.buildFromStringRepresentation((String)identifier)).build();
        DefaultComponentLocation location = new DefaultComponentLocation(Optional.of(identifier), Arrays.asList(new DefaultComponentLocation.DefaultLocationPart(name, Optional.of(typedComponentIdentifier), Optional.empty(), Optional.empty())));
        return location;
    }
}

