/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.model;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.munit.plugins.coverage.core.model.CoverageLocationPartTest;
import org.mule.munit.plugins.coverage.core.model.CoverageTypedComponentIdentifierTest;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import utils.ComponentLocationUtils;

public class CoverageComponentLocationTest {
    @Test
    public void validateEquals() {
        DefaultComponentLocation.DefaultLocationPart part = ComponentLocationUtils.flowPart("aFlow", "afile.xml", 2);
        ComponentLocation logger = ComponentLocationUtils.componentLocation("mule", "logger", TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of("anotherfile.xlm"), Optional.of(8), ComponentLocationUtils.asListOfParts(part, ComponentLocationUtils.processorsPart()));
        CoverageComponentLocation coverageComponentLocationOne = CoverageComponentLocation.fromComponentLocation((ComponentLocation)logger);
        CoverageComponentLocation coverageComponentLocationTwo = CoverageComponentLocation.fromComponentLocation((ComponentLocation)logger);
        MatcherAssert.assertThat((Object)coverageComponentLocationOne.equals((Object)coverageComponentLocationTwo), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)coverageComponentLocationTwo.equals((Object)coverageComponentLocationOne), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateFromComponentLocation() {
        DefaultComponentLocation.DefaultLocationPart part = ComponentLocationUtils.flowPart("aFlow", "afile.xml", 2);
        ComponentLocation logger = ComponentLocationUtils.componentLocation("mule", "logger", TypedComponentIdentifier.ComponentType.OPERATION, "0", Optional.of("anotherfile.xlm"), Optional.of(8), ComponentLocationUtils.asListOfParts(part, ComponentLocationUtils.processorsPart()));
        CoverageComponentLocation coverageLocation = CoverageComponentLocation.fromComponentLocation((ComponentLocation)logger);
        MatcherAssert.assertThat((Object)coverageLocation.getLocation(), (Matcher)Is.is((Object)logger.getLocation()));
        MatcherAssert.assertThat((Object)coverageLocation.getFileName(), (Matcher)Is.is((Object)logger.getFileName()));
        MatcherAssert.assertThat((Object)coverageLocation.getLineInFile(), (Matcher)Is.is((Object)logger.getLineInFile()));
        MatcherAssert.assertThat((Object)coverageLocation.getRootContainerName(), (Matcher)Is.is((Object)logger.getRootContainerName()));
        CoverageTypedComponentIdentifierTest.assertCoverageTypedComponentIdentifier(coverageLocation.getComponentIdentifier(), logger.getComponentIdentifier());
        CoverageLocationPartTest.assertCoverageLocationPart((LocationPart)coverageLocation.getParts().get(0), (LocationPart)part);
    }
}

