/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugins.coverage.core.model;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.munit.plugins.coverage.core.model.CoverageLocationPart;
import org.mule.munit.plugins.coverage.core.model.CoverageTypedComponentIdentifierTest;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import utils.ComponentLocationUtils;

public class CoverageLocationPartTest {
    @Test
    public void validateEquals() {
        DefaultComponentLocation.DefaultLocationPart part = ComponentLocationUtils.flowPart("aFlow", "afile.xml", 2);
        CoverageLocationPart coverageLocationPartOne = CoverageLocationPart.fromLocationPart((LocationPart)part);
        CoverageLocationPart coverageLocationPartTwo = CoverageLocationPart.fromLocationPart((LocationPart)part);
        MatcherAssert.assertThat((Object)coverageLocationPartOne.equals((Object)coverageLocationPartTwo), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)coverageLocationPartTwo.equals((Object)coverageLocationPartOne), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateEqualsNullFileName() {
        DefaultComponentLocation.DefaultLocationPart part = ComponentLocationUtils.flowPart("aFlow", null, 2);
        CoverageLocationPart coverageLocationPartOne = CoverageLocationPart.fromLocationPart((LocationPart)part);
        CoverageLocationPart coverageLocationPartTwo = CoverageLocationPart.fromLocationPart((LocationPart)part);
        MatcherAssert.assertThat((Object)coverageLocationPartOne.equals((Object)coverageLocationPartTwo), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)coverageLocationPartTwo.equals((Object)coverageLocationPartOne), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateEqualsEmptyFileName() {
        DefaultComponentLocation.DefaultLocationPart part = ComponentLocationUtils.flowPart("aFlow", "", 2);
        CoverageLocationPart coverageLocationPartOne = CoverageLocationPart.fromLocationPart((LocationPart)part);
        CoverageLocationPart coverageLocationPartTwo = CoverageLocationPart.fromLocationPart((LocationPart)part);
        MatcherAssert.assertThat((Object)coverageLocationPartOne.equals((Object)coverageLocationPartTwo), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)coverageLocationPartTwo.equals((Object)coverageLocationPartOne), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateEqualsNullLineNumber() {
        DefaultComponentLocation.DefaultLocationPart part = ComponentLocationUtils.flowPart("aFlow", "afile.xml", null);
        CoverageLocationPart coverageLocationPartOne = CoverageLocationPart.fromLocationPart((LocationPart)part);
        CoverageLocationPart coverageLocationPartTwo = CoverageLocationPart.fromLocationPart((LocationPart)part);
        MatcherAssert.assertThat((Object)coverageLocationPartOne.equals((Object)coverageLocationPartTwo), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)coverageLocationPartTwo.equals((Object)coverageLocationPartOne), (Matcher)Is.is((Object)true));
    }

    @Test
    public void validateFromComponentLocation() {
        DefaultComponentLocation.DefaultLocationPart part = ComponentLocationUtils.flowPart("aFlow", "afile.xml", 2);
        CoverageLocationPart coverageLocationPart = CoverageLocationPart.fromLocationPart((LocationPart)part);
        CoverageLocationPartTest.assertCoverageLocationPart((LocationPart)part, (LocationPart)coverageLocationPart);
    }

    public static void assertCoverageLocationPart(LocationPart coverageLocationPart, LocationPart part) {
        MatcherAssert.assertThat((Object)coverageLocationPart.getPartPath(), (Matcher)Is.is((Object)part.getPartPath()));
        MatcherAssert.assertThat((Object)coverageLocationPart.getFileName(), (Matcher)Is.is((Object)part.getFileName()));
        MatcherAssert.assertThat((Object)coverageLocationPart.getLineInFile(), (Matcher)Is.is((Object)part.getLineInFile()));
        CoverageTypedComponentIdentifierTest.assertCoverageTypedComponentIdentifier((TypedComponentIdentifier)coverageLocationPart.getPartIdentifier().get(), (TypedComponentIdentifier)part.getPartIdentifier().get());
    }
}

